// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Image_BalancedPixelInterpolation_HeaderFile
#define _Image_BalancedPixelInterpolation_HeaderFile

#ifndef _Image_PixelInterpolation_HeaderFile
#include <Image_PixelInterpolation.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Image_Image_HeaderFile
#include <Handle_Image_Image.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Image_DColorImage_HeaderFile
#include <Handle_Image_DColorImage.hxx>
#endif
#ifndef _Handle_Image_DIndexedImage_HeaderFile
#include <Handle_Image_DIndexedImage.hxx>
#endif
class Image_Image;
class Aspect_Pixel;
class Image_DColorImage;
class Aspect_ColorPixel;
class Image_DIndexedImage;
class Aspect_IndexPixel;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The class BalancedPixelInterpolation is used to compute a <br>
//!            SubPixel value on non integer Image coordinate <br>
//!          BalancedPixelInterpolation redefined a new method to compute <br>
//!	      a SubPixel value . <br>
//!	    The value is the proportional to the distance of the <br>
//!	      four nearest Image Pixel. <br>
//!			A          B <br>
//!			  SubPixel <br>
//!			C          D <br>
//!	    If VA, VB, VC, VD is the value of the four nearest Image <br>
//!	      Pixel, if ColDelta and RowDelta is the distance from non <br>
//!	      integer coordinate (FX,FY) to the upper left nearest Image <br>
//!	      Pixel , then : <br>
//!		ColDelta = FX - XA ; <br>
//!		RowDelta = FY - YA ; <br>
//!		CAB = ColDelta*( VB - VA ) + VA <br>
//!		CCD = ColDelta*( VD - VC ) + VD <br>
//!		V =  RowDelta*( CCD - CAB ) + CAB <br>
//!	      is the Image SubPixel value on non integer <br>
//!	      coordinate (FX,FY). <br>
class Image_BalancedPixelInterpolation  : public Image_PixelInterpolation {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Create a BalancedPixelInterpolation  object. <br>
Standard_EXPORT Image_BalancedPixelInterpolation();

//! Redefined the method to compute SubPixel's value <br>
//!	      on non integer Image coordinate. <br>
//!	    LowerX,LowerY,UpperX,UpperY is the Image Min Max, it's used <br>
//!	      to check if the SubPixel coordinate FX,FY is outside of <br>
//!	      image. <br>
//!          Return True  if Interpolation Succes. <br>
//!	    Return False if the SubPixel is out from Image. <br>
Standard_EXPORT virtual  Standard_Boolean Interpolate(const Handle(Image_Image)& aImage,const Standard_Real FX,const Standard_Real FY,const Standard_Integer LowerX,const Standard_Integer LowerY,const Standard_Integer UpperX,const Standard_Integer UpperY,Aspect_Pixel& RetPixel) const;

//! Compute SubPixel's value on non integer Image coordinate for <br>
//!	      DColorImage and ColorPixel. <br>
//!	    LowerX,LowerY,UpperX,UpperY is the Image Min Max, it's used <br>
//!	      to check if the SubPixel coordinate FX,FY is outside of <br>
//!	      image. <br>
//!          Return True  if Interpolation Succes. <br>
//!	    Return False if the SubPixel is out from Image. <br>
Standard_EXPORT virtual  Standard_Boolean Interpolate(const Handle(Image_DColorImage)& aImage,const Standard_Real FX,const Standard_Real FY,const Standard_Integer LowerX,const Standard_Integer LowerY,const Standard_Integer UpperX,const Standard_Integer UpperY,Aspect_ColorPixel& RetPixel) const;

//! Compute SubPixel's value on non integer Image coordinate for <br>
//!	      DIndexedImage and IndexPixel. <br>
//!	    LowerX,LowerY,UpperX,UpperY is the Image Min Max, it's used <br>
//!	      to check if the SubPixel coordinate X,Y is outside of <br>
//!	      image. <br>
//!          Return True  if Interpolation Succes. <br>
//!	    Return False if the SubPixel is out from Image. <br>
Standard_EXPORT virtual  Standard_Boolean Interpolate(const Handle(Image_DIndexedImage)& aImage,const Standard_Real FX,const Standard_Real FY,const Standard_Integer LowerX,const Standard_Integer LowerY,const Standard_Integer UpperX,const Standard_Integer UpperY,Aspect_IndexPixel& RetPixel) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
