// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MgtTopLoc_HeaderFile
#define _MgtTopLoc_HeaderFile

#ifndef _Handle_PTopLoc_Datum3D_HeaderFile
#include <Handle_PTopLoc_Datum3D.hxx>
#endif
#ifndef _Handle_TopLoc_Datum3D_HeaderFile
#include <Handle_TopLoc_Datum3D.hxx>
#endif
class PTopLoc_Datum3D;
class TopLoc_Datum3D;
class PTColStd_TransientPersistentMap;
class PTColStd_PersistentTransientMap;
class PTopLoc_Location;
class TopLoc_Location;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The package  MgtTopLoc provides methods   to store <br>
//!          and retrieve local    coordinate    systems.  i.e. <br>
//!          translationg them from Persistent to Transient and <br>
//!          vice-versa. <br>
//! <br>
//!          * Persistent local coordinate systems are provided <br>
//!          by the package PTopLoc. <br>
//! <br>
//!          * Transient local  coordinate systems are provided <br>
//!          by the package TopLoc. <br>
//! <br>
//!          This package keeps  track of previous translations <br>
//!          to preserve the incremental  feature of coordinate <br>
//!          systems. i.e.  once a  data  has  been translated, <br>
//!          translating it back will give the original data. <br>
//! <br>
//!          Two kinds of objects are managed : <br>
//! <br>
//!          *   Datum3D :  A  Datum3D   is an elementary local <br>
//!          coordinate system handled by reference. <br>
//! <br>
//!          *  Location   : A Location   is  a  complex  local <br>
//!          coordinate system   made   by  linking  elementary <br>
//!          coordinate systems  (Datum3D).  If  a Location  is <br>
//!          translated twice only the local coordinate systems <br>
//!          will be the same.  This  is not a problem  as  the <br>
//!          comparison of Locations is based on the comparison <br>
//!          of local coordinate systems. <br>
class MgtTopLoc  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Translate a  transient   Datum3D to  a  persistant <br>
//!          Datum3D. <br>
Standard_EXPORT static  Handle_PTopLoc_Datum3D Translate(const Handle(TopLoc_Datum3D)& D,PTColStd_TransientPersistentMap& M) ;

//! Translate a  persistant   Datum3D to  a  transient <br>
//!          Datum3D. <br>
Standard_EXPORT static  Handle_TopLoc_Datum3D Translate(const Handle(PTopLoc_Datum3D)& D,PTColStd_PersistentTransientMap& M) ;

//! Translate a non  storable  Location to  a storable <br>
//!          Location. <br>
Standard_EXPORT static  PTopLoc_Location Translate(const TopLoc_Location& L,PTColStd_TransientPersistentMap& M) ;

//! Translate a storable  Location  to a non  storable <br>
//!          Location. <br>
Standard_EXPORT static  TopLoc_Location Translate(const PTopLoc_Location& L,PTColStd_PersistentTransientMap& M) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
