// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_Environment_HeaderFile
#define _OSD_Environment_HeaderFile

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _OSD_Error_HeaderFile
#include <OSD_Error.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_ConstructionError;
class Standard_NullObject;
class OSD_OSDError;
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Management of system environment variables <br>
//!          An environment variable is composed of a variable name <br>
//!          and its value. <br>
class OSD_Environment  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates the object Environment. <br>
Standard_EXPORT OSD_Environment();

//! Creates an Environment variable initialized with value <br>
//!          set to an empty AsciiString. <br>
Standard_EXPORT OSD_Environment(const TCollection_AsciiString& Name);

//! Creates an Environment variable initialized with Value. <br>
Standard_EXPORT OSD_Environment(const TCollection_AsciiString& Name,const TCollection_AsciiString& Value);

//! Changes environment variable value. <br>
//!          Raises ConstructionError either if the string contains <br>
//!          characters not in range of ' '...'~' or if the string <br>
//!          contains the character '$' which is forbiden. <br>
Standard_EXPORT   void SetValue(const TCollection_AsciiString& Value) ;

//! Gets the value of an environment variable <br>
Standard_EXPORT   TCollection_AsciiString Value() ;

//! Changes environment variable name. <br>
//!          Raises ConstructionError either if the string contains <br>
//!          characters not in range of ' '...'~' or if the string <br>
//!          contains the character '$' which is forbiden. <br>
Standard_EXPORT   void SetName(const TCollection_AsciiString& name) ;

//! Gets the name of <me>. <br>
Standard_EXPORT   TCollection_AsciiString Name() const;

//! Sets the value of an environment variable <br>
//!          into system (physically). <br>
Standard_EXPORT   void Build() ;

//! Removes (physically) an environment variable <br>
Standard_EXPORT   void Remove() ;

//! Returns TRUE if an error occurs <br>
Standard_EXPORT   Standard_Boolean Failed() const;

//! Resets error counter to zero <br>
Standard_EXPORT   void Reset() ;

//! Raises OSD_Error <br>
Standard_EXPORT   void Perror() ;

//! Returns error number if 'Failed' is TRUE. <br>
Standard_EXPORT   Standard_Integer Error() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString myName;
TCollection_AsciiString myValue;
OSD_Error myError;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
