// File:      Standard_SStream.hxx
// Copyright: Open Cascade 2007
// Purpose:   Defines class Standard_SStream as equivalent (in fact, 
//            empty descendant) of C++ string stream.
//
//            Macro GetSString(SStream) is defined allowing to get
//            C string pointer from string stream.

#ifndef _Standard_SStream_HeaderFile
#define _Standard_SStream_HeaderFile

#ifndef _Standard_Stream_HeaderFile
#include <Standard_Stream.hxx>
#endif

#ifdef USE_STL_STREAM
  #include <sstream>
  #define GetSString(SStream) (char*)SStream.rdbuf()->str().c_str()
#else /* USE_STL_STREAM */
  #ifdef WNT
    #include <strstrea.h>
  #else
    #include <strstream.h>
  #endif
  #define GetSString(SStream) (char*)SStream.rdbuf()->str()
#endif /* USE_STL_STREAM */

class Handle_Standard_Type;

__Standard_API Handle_Standard_Type& Standard_SStream_Type_();
#ifdef USE_STL_STREAM
class Standard_SStream : public std::stringstream {
#else
class Standard_SStream : public strstream {
#endif
  public:
    Standard_EXPORT Standard_SStream();
    Standard_EXPORT Standard_SStream(ostream& );
    Standard_EXPORT ~Standard_SStream();
};

#endif
