// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepToTopoDS_Tool_HeaderFile
#define _StepToTopoDS_Tool_HeaderFile

#ifndef _StepToTopoDS_DataMapOfTRI_HeaderFile
#include <StepToTopoDS_DataMapOfTRI.hxx>
#endif
#ifndef _StepToTopoDS_PointVertexMap_HeaderFile
#include <StepToTopoDS_PointVertexMap.hxx>
#endif
#ifndef _StepToTopoDS_PointEdgeMap_HeaderFile
#include <StepToTopoDS_PointEdgeMap.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Transfer_TransientProcess_HeaderFile
#include <Handle_Transfer_TransientProcess.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_StepShape_TopologicalRepresentationItem_HeaderFile
#include <Handle_StepShape_TopologicalRepresentationItem.hxx>
#endif
#ifndef _Handle_StepGeom_CartesianPoint_HeaderFile
#include <Handle_StepGeom_CartesianPoint.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
class Transfer_TransientProcess;
class StepToTopoDS_DataMapOfTRI;
class StepShape_TopologicalRepresentationItem;
class TopoDS_Shape;
class StepToTopoDS_PointPair;
class TopoDS_Edge;
class StepGeom_CartesianPoint;
class TopoDS_Vertex;
class Geom_Surface;
class Geom_Curve;
class Geom2d_Curve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This Tool Class provides Information to build <br>
//!          a Cas.Cad BRep from a ProSTEP Shape model. <br>
class StepToTopoDS_Tool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT StepToTopoDS_Tool();


Standard_EXPORT StepToTopoDS_Tool(const StepToTopoDS_DataMapOfTRI& Map,const Handle(Transfer_TransientProcess)& TP);


Standard_EXPORT   void Init(const StepToTopoDS_DataMapOfTRI& Map,const Handle(Transfer_TransientProcess)& TP) ;


Standard_EXPORT   Standard_Boolean IsBound(const Handle(StepShape_TopologicalRepresentationItem)& TRI) ;


Standard_EXPORT   void Bind(const Handle(StepShape_TopologicalRepresentationItem)& TRI,const TopoDS_Shape& S) ;


Standard_EXPORT  const TopoDS_Shape& Find(const Handle(StepShape_TopologicalRepresentationItem)& TRI) ;


Standard_EXPORT   void ClearEdgeMap() ;


Standard_EXPORT   Standard_Boolean IsEdgeBound(const StepToTopoDS_PointPair& PP) ;


Standard_EXPORT   void BindEdge(const StepToTopoDS_PointPair& PP,const TopoDS_Edge& E) ;


Standard_EXPORT  const TopoDS_Edge& FindEdge(const StepToTopoDS_PointPair& PP) ;


Standard_EXPORT   void ClearVertexMap() ;


Standard_EXPORT   Standard_Boolean IsVertexBound(const Handle(StepGeom_CartesianPoint)& PG) ;


Standard_EXPORT   void BindVertex(const Handle(StepGeom_CartesianPoint)& P,const TopoDS_Vertex& V) ;


Standard_EXPORT  const TopoDS_Vertex& FindVertex(const Handle(StepGeom_CartesianPoint)& P) ;


Standard_EXPORT   void ComputePCurve(const Standard_Boolean B) ;


Standard_EXPORT   Standard_Boolean ComputePCurve() const;


Standard_EXPORT   Handle_Transfer_TransientProcess TransientProcess() const;


Standard_EXPORT   void AddContinuity(const Handle(Geom_Surface)& GeomSurf) ;


Standard_EXPORT   void AddContinuity(const Handle(Geom_Curve)& GeomCurve) ;


Standard_EXPORT   void AddContinuity(const Handle(Geom2d_Curve)& GeomCur2d) ;


Standard_EXPORT   Standard_Integer C0Surf() const;


Standard_EXPORT   Standard_Integer C1Surf() const;


Standard_EXPORT   Standard_Integer C2Surf() const;


Standard_EXPORT   Standard_Integer C0Cur2() const;


Standard_EXPORT   Standard_Integer C1Cur2() const;


Standard_EXPORT   Standard_Integer C2Cur2() const;


Standard_EXPORT   Standard_Integer C0Cur3() const;


Standard_EXPORT   Standard_Integer C1Cur3() const;


Standard_EXPORT   Standard_Integer C2Cur3() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
StepToTopoDS_DataMapOfTRI myDataMap;
StepToTopoDS_PointVertexMap myVertexMap;
StepToTopoDS_PointEdgeMap myEdgeMap;
Standard_Boolean myComputePC;
Handle_Transfer_TransientProcess myTransProc;
Standard_Integer myNbC0Surf;
Standard_Integer myNbC1Surf;
Standard_Integer myNbC2Surf;
Standard_Integer myNbC0Cur2;
Standard_Integer myNbC1Cur2;
Standard_Integer myNbC2Cur2;
Standard_Integer myNbC0Cur3;
Standard_Integer myNbC1Cur3;
Standard_Integer myNbC2Cur3;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
