// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TCollection_HAsciiString_HeaderFile
#define _TCollection_HAsciiString_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Character_HeaderFile
#include <Standard_Character.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TCollection_HExtendedString_HeaderFile
#include <Handle_TCollection_HExtendedString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_NullObject;
class Standard_OutOfRange;
class Standard_NumericError;
class Standard_NegativeValue;
class TCollection_AsciiString;
class TCollection_HExtendedString;


//! A variable-length sequence of ASCII characters <br>
//! (normal 8-bit character type). It provides editing <br>
//! operations with built-in memory management to <br>
//! make HAsciiString objects easier to use than ordinary character arrays. <br>
//! HAsciiString objects are handles to strings. <br>
//! -   HAsciiString strings may be shared by several objects. <br>
//! -   You may use an AsciiString object to get the actual string. <br>
//! Note: HAsciiString objects use an AsciiString string as a field. <br>
class TCollection_HAsciiString : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Initializes a HAsciiString to an empty AsciiString. <br>
Standard_EXPORT TCollection_HAsciiString();

//! Initializes a HAsciiString with a CString. <br>
Standard_EXPORT TCollection_HAsciiString(const Standard_CString message);

//! Initializes a HAsciiString with a single character. <br>
Standard_EXPORT TCollection_HAsciiString(const Standard_Character aChar);

//! Initializes a HAsciiString with <length> space allocated. <br>
//! and filled with <filler>.This is useful for buffers. <br>
Standard_EXPORT TCollection_HAsciiString(const Standard_Integer length,const Standard_Character filler);

//! Initializes a HAsciiString with an integer value <br>
Standard_EXPORT TCollection_HAsciiString(const Standard_Integer value);

//! Initializes a HAsciiString with a real value <br>
Standard_EXPORT TCollection_HAsciiString(const Standard_Real value);

//! Initializes a HAsciiString with a HAsciiString. <br>
Standard_EXPORT TCollection_HAsciiString(const TCollection_AsciiString& aString);

//! Initializes a HAsciiString with a HAsciiString. <br>
Standard_EXPORT TCollection_HAsciiString(const Handle(TCollection_HAsciiString)& aString);

//! Initializes a HAsciiString with a HAsciiString. <br>
//!          If replaceNonAscii is non-null charecter, it will be used <br>
//!          in place of any non-ascii character found in the source string. <br>
//!          Otherwise, raises OutOfRange exception if at least one character <br>
//!          in the source string is not in the "Ascii range". <br>
Standard_EXPORT TCollection_HAsciiString(const Handle(TCollection_HExtendedString)& aString,const Standard_Character replaceNonAscii);
//! Appends <other>  to me. <br>
  void AssignCat(const Standard_CString other) ;
//! Appends <other>  to me. <br>
//!  Example:  aString = aString + anotherString <br>
  void AssignCat(const Handle(TCollection_HAsciiString)& other) ;

//! Converts the first character into its corresponding <br>
//! upper-case character and the other characters into lowercase. <br>
//!  Example: <br>
//! before <br>
//!   me = "hellO " <br>
//! after <br>
//!   me = "Hello " <br>
Standard_EXPORT   void Capitalize() ;

//!  Creates a new string by concatenation of this <br>
//! ASCII string and the other ASCII string. <br>
//!  Example: <br>
//!    aString = aString + anotherString <br>
//!    aString = aString + "Dummy" <br>
//!    aString contains "I say " <br>
//!    aString = aString + "Hello " + "Dolly" <br>
//! gives "I say Hello Dolly" <br>
//!  Warning: To catenate more than one CString, you must put a String before. <br>
//! So the following example is WRONG ! <br>
//!      aString = "Hello " + "Dolly"  THIS IS NOT ALLOWED <br>
//! This rule is applicable to AssignCat (operator +=) too. <br>
Standard_EXPORT   Handle_TCollection_HAsciiString Cat(const Standard_CString other) const;

//! Creates a new string by concatenation of this <br>
//! ASCII string and the other ASCII string. <br>
//!  Example:  aString = aString + anotherString <br>
Standard_EXPORT   Handle_TCollection_HAsciiString Cat(const Handle(TCollection_HAsciiString)& other) const;

//! Modifies this ASCII string so that its length <br>
//! becomes equal to Width and the new characters <br>
//! are equal to Filler. New characters are added <br>
//! both at the beginning and at the end of this string. <br>
//! If Width is less than the length of this ASCII string, nothing happens. <br>
//! Example <br>
//! Handle(TCollection_HAsciiString) <br>
//! myAlphabet <br>
//!    = new <br>
//! TCollection_HAsciiString <br>
//! ("abcdef"); <br>
//! myAlphabet->Center(9,' '); <br>
//! assert ( !strcmp( <br>
//! myAlphabet->ToCString(), <br>
//!        " abcdef ") ); <br>
Standard_EXPORT   void Center(const Standard_Integer Width,const Standard_Character Filler) ;

//! Replaces all characters equal to aChar by <br>
//! NewChar in this ASCII string. The substitution is <br>
//! case sensitive if CaseSensitive is true (default value). <br>
//! If you do not use the default case sensitive <br>
//! option, it does not matter whether aChar is upper-case or not. <br>
//! Example <br>
//! Handle(TCollection_HAsciiString) <br>
//! myMistake = new <br>
//! TCollection_HAsciiString <br>
//! ("Hather"); <br>
//! myMistake->ChangeAll('H','F'); <br>
//! assert ( !strcmp( <br>
//! myMistake->ToCString(), <br>
//! "Father") ); <br>
Standard_EXPORT   void ChangeAll(const Standard_Character aChar,const Standard_Character NewChar,const Standard_Boolean CaseSensitive = Standard_True) ;

//! Removes all characters contained in <me>. <br>
//! This produces an empty HAsciiString. <br>
Standard_EXPORT   void Clear() ;

//! Returns the index of the first character of <me> that is <br>
//! present in <Set>. <br>
//! The search begins to the index FromIndex and ends to the <br>
//! the index ToIndex. <br>
//! Returns zero if failure. <br>
//! Raises an exception if FromIndex or ToIndex is out of range <br>
//!  Example: <br>
//! before <br>
//!   me = "aabAcAa", S = "Aa", FromIndex = 1, Toindex = 7 <br>
//! after <br>
//!   me = "aabAcAa" <br>
//! returns <br>
//!   1 <br>
Standard_EXPORT   Standard_Integer FirstLocationInSet(const Handle(TCollection_HAsciiString)& Set,const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;

//! Returns the index of the first character of <me> <br>
//! that is not present in the set <Set>. <br>
//! The search begins to the index FromIndex and ends to the <br>
//! the index ToIndex in <me>. <br>
//! Returns zero if failure. <br>
//! Raises an exception if FromIndex or ToIndex is out of range. <br>
//!  Example: <br>
//! before <br>
//!   me = "aabAcAa", S = "Aa", FromIndex = 1, Toindex = 7 <br>
//! after <br>
//!   me = "aabAcAa" <br>
//! returns <br>
//!   3 <br>
Standard_EXPORT   Standard_Integer FirstLocationNotInSet(const Handle(TCollection_HAsciiString)& Set,const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;

//! Insert a Character at position <where>. <br>
//!  Example: <br>
//!    aString contains "hy not ?" <br>
//!    aString.Insert(1,'W'); gives "Why not ?" <br>
//!    aString contains "Wh" <br>
//!    aString.Insert(3,'y'); gives "Why" <br>
//!    aString contains "Way" <br>
//!    aString.Insert(2,'h'); gives "Why" <br>
Standard_EXPORT   void Insert(const Standard_Integer where,const Standard_Character what) ;

//! Insert a HAsciiString at position <where>. <br>
Standard_EXPORT   void Insert(const Standard_Integer where,const Standard_CString what) ;

//! Insert a HAsciiString at position <where>. <br>
Standard_EXPORT   void Insert(const Standard_Integer where,const Handle(TCollection_HAsciiString)& what) ;

//! Inserts the other ASCII string a after a specific index in the string <me> <br>
//!  Example: <br>
//! before <br>
//!   me = "cde" , Index = 0 , other = "ab" <br>
//! after <br>
//!   me = "abcde" , other = "ab" <br>
Standard_EXPORT   void InsertAfter(const Standard_Integer Index,const Handle(TCollection_HAsciiString)& other) ;

//! Inserts the other ASCII string a before a specific index in the string <me> <br>
//! Raises an exception if Index is out of bounds <br>
//!  Example: <br>
//! before <br>
//!   me = "cde" , Index = 1 , other = "ab" <br>
//! after <br>
//!   me = "abcde" , other = "ab" <br>
Standard_EXPORT   void InsertBefore(const Standard_Integer Index,const Handle(TCollection_HAsciiString)& other) ;

//!  Returns True if the string <me> contains zero character <br>
Standard_EXPORT   Standard_Boolean IsEmpty() const;

//! Returns TRUE if <me> is 'ASCII' less than <other>. <br>
Standard_EXPORT   Standard_Boolean IsLess(const Handle(TCollection_HAsciiString)& other) const;

//! Returns TRUE if <me> is 'ASCII' greater than <other>. <br>
Standard_EXPORT   Standard_Boolean IsGreater(const Handle(TCollection_HAsciiString)& other) const;

//! Converts a HAsciiString containing a numeric expression to <br>
//! an Integer. <br>
//!  Example: "215" returns 215. <br>
Standard_EXPORT   Standard_Integer IntegerValue() const;

//! Returns True if the string contains an integer value. <br>
Standard_EXPORT   Standard_Boolean IsIntegerValue() const;

//! Returns True if the string contains a real value. <br>
Standard_EXPORT   Standard_Boolean IsRealValue() const;

//! Returns True if the string contains only ASCII characters <br>
//! between ' ' and '~'. <br>
//! This means no control character and no extended ASCII code. <br>
Standard_EXPORT   Standard_Boolean IsAscii() const;

//! Returns True if the string S not contains same characters than <br>
//! the string <me>. <br>
Standard_EXPORT   Standard_Boolean IsDifferent(const Handle(TCollection_HAsciiString)& S) const;

//! Returns True if the string S contains same characters than the <br>
//! string <me>. <br>
Standard_EXPORT   Standard_Boolean IsSameString(const Handle(TCollection_HAsciiString)& S) const;

//! Returns True if the string S contains same characters than the <br>
//! string <me>. <br>
Standard_EXPORT   Standard_Boolean IsSameString(const Handle(TCollection_HAsciiString)& S,const Standard_Boolean CaseSensitive) const;

//! Removes all space characters in the begining of the string <br>
Standard_EXPORT   void LeftAdjust() ;

//! Left justify. <br>
//! Length becomes equal to Width and the new characters are <br>
//! equal to Filler <br>
//! if Width < Length nothing happens <br>
//! Raises an exception if Width is less than zero <br>
//!  Example: <br>
//! before <br>
//!   me = "abcdef" , Width = 9 , Filler = ' ' <br>
//! after <br>
//!   me = "abcdef   " <br>
Standard_EXPORT   void LeftJustify(const Standard_Integer Width,const Standard_Character Filler) ;
//! Returns number of characters in <me>. <br>
//! This is the same functionality as 'strlen' in C. <br>
  Standard_Integer Length() const;

//! returns an index in the string <me> of the first occurence <br>
//! of the string S in the string <me> from the starting index <br>
//! FromIndex to the ending index ToIndex <br>
//! returns zero if failure <br>
//! Raises an exception if FromIndex or ToIndex is out of range. <br>
//!  Example: <br>
//! before <br>
//!   me = "aabAaAa", S = "Aa", FromIndex = 1, ToIndex = 7 <br>
//! after <br>
//!   me = "aabAaAa" <br>
//! returns <br>
//!   4 <br>
Standard_EXPORT   Standard_Integer Location(const Handle(TCollection_HAsciiString)& other,const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;

//! Returns the index of the nth occurence of the character C <br>
//! in the string <me> from the starting index FromIndex to the <br>
//! ending index ToIndex. <br>
//! Returns zero if failure. <br>
//! Raises an exception if FromIndex or ToIndex is out of range <br>
//!  Example: <br>
//! before <br>
//!   me = "aabAa", N = 3, C = 'a', FromIndex = 1, ToIndex = 5 <br>
//! after <br>
//!   me = "aabAa" <br>
//! returns 5 <br>
Standard_EXPORT   Standard_Integer Location(const Standard_Integer N,const Standard_Character C,const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;

//! Converts <me> to its lower-case equivalent. <br>
Standard_EXPORT   void LowerCase() ;

//! Inserts the other string at the begining of the string <me> <br>
//!  Example: <br>
//! before <br>
//!   me = "cde" , S = "ab" <br>
//! after <br>
//!   me = "abcde" , S = "ab" <br>
Standard_EXPORT   void Prepend(const Handle(TCollection_HAsciiString)& other) ;

//! Prints this string on the stream <astream>. <br>
Standard_EXPORT   void Print(Standard_OStream& astream) const;

//! Converts a string containing a numeric expression to a Real. <br>
//!  Example: <br>
//!  "215" returns 215.0. <br>
//!  "3.14159267" returns 3.14159267. <br>
Standard_EXPORT   Standard_Real RealValue() const;

//! Remove all the occurences of the character C in the string <br>
//!  Example: <br>
//! before <br>
//!   me = "HellLLo", C = 'L' , CaseSensitive = True <br>
//! after <br>
//!   me = "Hello" <br>
Standard_EXPORT   void RemoveAll(const Standard_Character C,const Standard_Boolean CaseSensitive) ;

//! Removes every <what> characters from <me> <br>
Standard_EXPORT   void RemoveAll(const Standard_Character what) ;

//! Erases <ahowmany> characters from position <where>, <br>
//! <where> included. <br>
//!  Example: <br>
//!    aString contains "Hello" <br>
//!    aString.Erase(2,2) erases 2 characters from position 1 <br>
//! This gives "Hlo". <br>
Standard_EXPORT   void Remove(const Standard_Integer where,const Standard_Integer ahowmany = 1) ;

//! Removes all space characters at the end of the string. <br>
Standard_EXPORT   void RightAdjust() ;

//! Right justify. <br>
//! Length becomes equal to Width and the new characters are <br>
//! equal to Filler <br>
//! if Width < Length nothing happens <br>
//! Raises an exception if Width is less than zero <br>
//!  Example: <br>
//! before <br>
//!   me = "abcdef" , Width = 9 , Filler = ' ' <br>
//! after <br>
//!   me = "   abcdef" <br>
Standard_EXPORT   void RightJustify(const Standard_Integer Width,const Standard_Character Filler) ;

//! Searches a CString in <me> from the beginning <br>
//! and returns position of first item <what> matching. <br>
//! It returns -1 if not found. <br>
//!  Example: <br>
//!   aString contains "Sample single test" <br>
//!   aString.Search("le") returns 5 <br>
Standard_EXPORT   Standard_Integer Search(const Standard_CString what) const;

//! Searches a String in <me> from the beginning <br>
//! and returns position of first item <what> matching. <br>
//! it returns -1 if not found. <br>
Standard_EXPORT   Standard_Integer Search(const Handle(TCollection_HAsciiString)& what) const;

//! Searches a CString in a String from the end <br>
//! and returns position of first item <what> matching. <br>
//! It returns -1 if not found. <br>
//!  Example: <br>
//! aString contains "Sample single test" <br>
//! aString.SearchFromEnd("le") returns 12 <br>
Standard_EXPORT   Standard_Integer SearchFromEnd(const Standard_CString what) const;

//! Searches a HAsciiString in another HAsciiString from the end <br>
//! and returns position of first item <what> matching. <br>
//! It returns -1 if not found. <br>
Standard_EXPORT   Standard_Integer SearchFromEnd(const Handle(TCollection_HAsciiString)& what) const;

//! Replaces one character in the string at position <where>. <br>
//! If <where> is less than zero or greater than the length of <me> <br>
//! an exception is raised. <br>
//!  Example: <br>
//!  aString contains "Garbake" <br>
//!  astring.Replace(6,'g')  gives <me> = "Garbage" <br>
Standard_EXPORT   void SetValue(const Standard_Integer where,const Standard_Character what) ;

//! Replaces a part of <me> in the string at position <where>. <br>
//! If <where> is less than zero or greater than the length of <me> <br>
//! an exception is raised. <br>
//!  Example: <br>
//!  aString contains "Garbake" <br>
//!  astring.Replace(6,'g')  gives <me> = "Garbage" <br>
Standard_EXPORT   void SetValue(const Standard_Integer where,const Standard_CString what) ;

//! Replaces a part of <me> by another string. <br>
Standard_EXPORT   void SetValue(const Standard_Integer where,const Handle(TCollection_HAsciiString)& what) ;

//! Splits a HAsciiString into two sub-strings. <br>
//!  Example: <br>
//!  aString contains "abcdefg" <br>
//!  aString.Split(3) gives <me> = "abc" and returns "defg" <br>
Standard_EXPORT   Handle_TCollection_HAsciiString Split(const Standard_Integer where) ;

//! Creation of a sub-string of the string <me>. <br>
//! The sub-string starts to the index Fromindex and ends <br>
//! to the index ToIndex. <br>
//! Raises an exception if ToIndex or FromIndex is out of <br>
//! bounds <br>
//!  Example: <br>
//! before <br>
//!   me = "abcdefg", ToIndex=3, FromIndex=6 <br>
//! after <br>
//!   me = "abcdefg" <br>
//! returns <br>
//!   "cdef" <br>
Standard_EXPORT   Handle_TCollection_HAsciiString SubString(const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;
//! Returns pointer to string (char *) <br>
//! This is useful for some casual manipulations <br>
//! Because this "char *" is 'const', you can't modify its contents. <br>
  Standard_CString ToCString() const;

//! Extracts <whichone> token from <me>. <br>
//! By default, the <separators> is set to space and tabulation. <br>
//! By default, the token extracted is the first one (whichone = 1). <br>
//! <separators> contains all separators you need. <br>
//! If no token indexed by <whichone> is found, it returns an empty String. <br>
//!  Example: <br>
//!    aString contains "This is a     message" <br>
//!    aString.Token()  returns "This" <br>
//!    aString.Token(" ",4) returns "message" <br>
//!    aString.Token(" ",2) returns "is" <br>
//!    aString.Token(" ",9) returns "" <br>
//! Other separators than space character and tabulation are allowed <br>
//!    aString contains "1234; test:message   , value" <br>
//!    aString.Token("; :,",4) returns "value" <br>
//!    aString.Token("; :,",2) returns "test" <br>
Standard_EXPORT   Handle_TCollection_HAsciiString Token(const Standard_CString separators = " \t",const Standard_Integer whichone = 1) const;

//! Truncates <me> to <ahowmany> characters. <br>
//!  Example:  me = "Hello Dolly" -> Trunc(3) -> me = "Hel" <br>
Standard_EXPORT   void Trunc(const Standard_Integer ahowmany) ;

//! Converts <me> to its upper-case equivalent. <br>
Standard_EXPORT   void UpperCase() ;

//! Length of the string ignoring all spaces (' ') and the <br>
//! control character at the end. <br>
Standard_EXPORT   Standard_Integer UsefullLength() const;

//! Returns character at position <where> in <me>. <br>
//! If <where> is less than zero or greater than the lenght of <br>
//! <me>, an exception is raised. <br>
//!  Example: <br>
//!   aString contains "Hello" <br>
//!   aString.Value(2) returns 'e' <br>
Standard_EXPORT   Standard_Character Value(const Standard_Integer where) const;
//! Returns the field myString. <br>
 const TCollection_AsciiString& String() const;


Standard_EXPORT   Handle_TCollection_HAsciiString ShallowCopy() const;


Standard_EXPORT   void ShallowDump(Standard_OStream& s) const;


Standard_EXPORT   Standard_Boolean IsSameState(const Handle(TCollection_HAsciiString)& other) const;
//Standard_EXPORT ~TCollection_HAsciiString();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString myString;


};


#include <TCollection_HAsciiString.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//
inline Handle_TCollection_HAsciiString ShallowCopy(const Handle_TCollection_HAsciiString& me) {
 return me->ShallowCopy();
}

inline void ShallowDump(const Handle_TCollection_HAsciiString& me,Standard_OStream& s) {
 me->ShallowDump(s);
}



#endif
