// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_UnitSentence_HeaderFile
#define _Units_UnitSentence_HeaderFile

#ifndef _Units_Sentence_HeaderFile
#include <Units_Sentence.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Units_QuantitiesSequence_HeaderFile
#include <Handle_Units_QuantitiesSequence.hxx>
#endif
class Units_QuantitiesSequence;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This   class describes   all    the  facilities to <br>
//!          manipulate and compute units contained in a string <br>
//!          expression. <br>
class Units_UnitSentence  : public Units_Sentence {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates   and   returns a   UnitSentence.   The string <br>
//!          <astring> describes in natural  language the  unit  or <br>
//!          the composed unit to be analysed. <br>
Standard_EXPORT Units_UnitSentence(const Standard_CString astring);

//! Creates  and returns    a  UnitSentence.  The   string <br>
//!          <astring> describes in natural language the unit to be <br>
//!          analysed.   The    sequence     of physical quantities <br>
//!          <asequenceofquantities>   describes    the   available <br>
//!          dictionary of units you want to use. <br>
Standard_EXPORT Units_UnitSentence(const Standard_CString astring,const Handle(Units_QuantitiesSequence)& aquantitiessequence);

//! Analyzes   the sequence  of   tokens  created  by  the <br>
//!          constructor to  find  the true significance   of  each <br>
//!          token. <br>
Standard_EXPORT   void Analyse() ;

//! For each token which  represents a unit, finds  in the <br>
//!          sequence    of    physical   quantities      all   the <br>
//!          characteristics of the unit found. <br>
Standard_EXPORT   void SetUnits(const Handle(Units_QuantitiesSequence)& aquantitiessequence) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
