// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gp_Hypr_HeaderFile
#define _gp_Hypr_HeaderFile

#ifndef _gp_Ax2_HeaderFile
#include <gp_Ax2.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class Standard_DomainError;
class gp_Ax2;
class gp_Ax1;
class gp_Pnt;
class gp_Trsf;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& gp_Hypr_Type_();

//! Describes a branch of a hyperbola in 3D space. <br>
//! A hyperbola is defined by its major and minor radii and <br>
//! positioned in space with a coordinate system (a gp_Ax2 <br>
//! object) of which: <br>
//! -   the origin is the center of the hyperbola, <br>
//! -   the "X Direction" defines the major axis of the <br>
//!   hyperbola, and <br>
//! - the "Y Direction" defines the minor axis of the hyperbola. <br>
//! The origin, "X Direction" and "Y Direction" of this <br>
//! coordinate system together define the plane of the <br>
//! hyperbola. This coordinate system is the "local <br>
//! coordinate system" of the hyperbola. In this coordinate <br>
//! system, the equation of the hyperbola is: <br>
//! X*X/(MajorRadius**2)-Y*Y/(MinorRadius**2) = 1.0 <br>
//! The branch of the hyperbola described is the one located <br>
//! on the positive side of the major axis. <br>
//! The "main Direction" of the local coordinate system is a <br>
//! normal vector to the plane of the hyperbola. This vector <br>
//! gives an implicit orientation to the hyperbola. We refer to <br>
//! the "main Axis" of the local coordinate system as the <br>
//! "Axis" of the hyperbola. <br>
//! The following schema shows the plane of the hyperbola, <br>
//! and in it, the respective positions of the three branches of <br>
//! hyperbolas constructed with the functions OtherBranch, <br>
//! ConjugateBranch1, and ConjugateBranch2: <br>
class gp_Hypr  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 
//! Creates of an indefinite hyperbola. <br>
gp_Hypr();
//! Creates a hyperbola with radii MajorRadius and <br>
//!   MinorRadius, positioned in the space by the <br>
//!   coordinate system A2 such that: <br>
//!   -   the origin of A2 is the center of the hyperbola, <br>
//!   -   the "X Direction" of A2 defines the major axis of <br>
//!    the hyperbola, that is, the major radius <br>
//!    MajorRadius is measured along this axis, and <br>
//!   -   the "Y Direction" of A2 defines the minor axis of <br>
//!    the hyperbola, that is, the minor radius <br>
//!    MinorRadius is measured along this axis. <br>
//! Note: This class does not prevent the creation of a <br>
//! hyperbola where: <br>
//! -   MajorAxis is equal to MinorAxis, or <br>
//! -   MajorAxis is less than MinorAxis. <br>
//! Exceptions <br>
//! Standard_ConstructionError if MajorAxis or MinorAxis is negative. <br>
//!     Raises ConstructionError if MajorRadius < 0.0 or MinorRadius < 0.0 <br>//! Raised if MajorRadius < 0.0 or MinorRadius < 0.0 <br>
gp_Hypr(const gp_Ax2& A2,const Standard_Real MajorRadius,const Standard_Real MinorRadius);
//! Modifies this hyperbola, by redefining its local coordinate <br>
//! system so that: <br>
//! -   its origin and "main Direction" become those of the <br>
//!   axis A1 (the "X Direction" and "Y Direction" are then <br>
//!   recomputed in the same way as for any gp_Ax2). <br>
//! Raises ConstructionError if the direction of A1 is parallel to the direction of <br>
//!  the "XAxis" of the hyperbola. <br>
  void SetAxis(const gp_Ax1& A1) ;
//! Modifies this hyperbola, by redefining its local coordinate <br>
//! system so that its origin becomes P. <br>
  void SetLocation(const gp_Pnt& P) ;

//! Modifies the major  radius of this hyperbola. <br>
//! Exceptions <br>
//! Standard_ConstructionError if MajorRadius is negative. <br>
  void SetMajorRadius(const Standard_Real MajorRadius) ;

//! Modifies the minor  radius of this hyperbola. <br>
//! Exceptions <br>
//! Standard_ConstructionError if MinorRadius is negative. <br>
  void SetMinorRadius(const Standard_Real MinorRadius) ;
//! Modifies this hyperbola, by redefining its local coordinate <br>
//! system so that it becomes A2. <br>
  void SetPosition(const gp_Ax2& A2) ;

//!  In the local coordinate system of the hyperbola the equation of <br>
//!  the hyperbola is (X*X)/(A*A) - (Y*Y)/(B*B) = 1.0 and the <br>
//!  equation of the first asymptote is Y = (B/A)*X <br>
//!  where A is the major radius and B is the minor radius. Raises ConstructionError if MajorRadius = 0.0 <br>
  gp_Ax1 Asymptote1() const;

//!  In the local coordinate system of the hyperbola the equation of <br>
//!  the hyperbola is (X*X)/(A*A) - (Y*Y)/(B*B) = 1.0 and the <br>
//!  equation of the first asymptote is Y = -(B/A)*X. <br>
//!  where A is the major radius and B is the minor radius. Raises ConstructionError if MajorRadius = 0.0 <br>
  gp_Ax1 Asymptote2() const;
//! Returns the axis passing through the center, <br>
//! and normal to the plane of this hyperbola. <br>
 const gp_Ax1& Axis() const;

//!  Computes the branch of hyperbola which is on the positive side of the <br>
//!  "YAxis" of <me>. <br>
  gp_Hypr ConjugateBranch1() const;

//!  Computes the branch of hyperbola which is on the negative side of the <br>
//!  "YAxis" of <me>. <br>
  gp_Hypr ConjugateBranch2() const;

//!  This directrix is the line normal to the XAxis of the hyperbola <br>
//!  in the local plane (Z = 0) at a distance d = MajorRadius / e <br>
//!  from the center of the hyperbola, where e is the eccentricity of <br>
//!  the hyperbola. <br>
//!  This line is parallel to the "YAxis". The intersection point <br>
//!  between the directrix1 and the "XAxis" is the "Location" point <br>
//!  of the directrix1. This point is on the positive side of the <br>
//!  "XAxis". <br>
  gp_Ax1 Directrix1() const;

//!  This line is obtained by the symmetrical transformation <br>
//!  of "Directrix1" with respect to the "YAxis" of the hyperbola. <br>
  gp_Ax1 Directrix2() const;

//!  Returns the excentricity of the hyperbola (e > 1). <br>
//!  If f is the distance between the location of the hyperbola <br>
//!  and the Focus1 then the eccentricity e = f / MajorRadius. Raises DomainError if MajorRadius = 0.0 <br>
  Standard_Real Eccentricity() const;

//!  Computes the focal distance. It is the distance between the <br>
//!  the two focus of the hyperbola. <br>
  Standard_Real Focal() const;

//!  Returns the first focus of the hyperbola. This focus is on the <br>
//!  positive side of the "XAxis" of the hyperbola. <br>
  gp_Pnt Focus1() const;

//!  Returns the second focus of the hyperbola. This focus is on the <br>
//!  negative side of the "XAxis" of the hyperbola. <br>
  gp_Pnt Focus2() const;

//!  Returns  the location point of the hyperbola. It is the <br>
//!  intersection point between the "XAxis" and the "YAxis". <br>
 const gp_Pnt& Location() const;

//!  Returns the major radius of the hyperbola. It is the radius <br>
//!  on the "XAxis" of the hyperbola. <br>
  Standard_Real MajorRadius() const;

//!  Returns the minor radius of the hyperbola. It is the radius <br>
//!  on the "YAxis" of the hyperbola. <br>
  Standard_Real MinorRadius() const;

//!  Returns the branch of hyperbola obtained by doing the <br>
//!  symmetrical transformation of <me> with respect to the <br>
//!  "YAxis"  of <me>. <br>
  gp_Hypr OtherBranch() const;

//!  Returns p = (e * e - 1) * MajorRadius where e is the <br>
//!  eccentricity of the hyperbola. <br>
//! Raises DomainError if MajorRadius = 0.0 <br>
  Standard_Real Parameter() const;
//! Returns the coordinate system of the hyperbola. <br>
 const gp_Ax2& Position() const;
//! Computes an axis, whose <br>
//! -   the origin is the center of this hyperbola, and <br>
//! -   the unit vector is the "X Direction" <br>
//!   of the local coordinate system of this hyperbola. <br>
//! These axes are, the major axis (the "X <br>
//! Axis") and  of this hyperboReturns the "XAxis" of the hyperbola. <br>
  gp_Ax1 XAxis() const;
//!      Computes an axis, whose <br>
//! -   the origin is the center of this hyperbola, and <br>
//! -   the unit vector is the "Y Direction" <br>
//!   of the local coordinate system of this hyperbola. <br>
//! These axes are the minor axis (the "Y Axis") of this hyperbola <br>
  gp_Ax1 YAxis() const;


Standard_EXPORT   void Mirror(const gp_Pnt& P) ;


//!  Performs the symmetrical transformation of an hyperbola with <br>
//!  respect  to the point P which is the center of the symmetry. <br>
Standard_EXPORT   gp_Hypr Mirrored(const gp_Pnt& P) const;


Standard_EXPORT   void Mirror(const gp_Ax1& A1) ;


//!  Performs the symmetrical transformation of an hyperbola with <br>
//!  respect to an axis placement which is the axis of the symmetry. <br>
Standard_EXPORT   gp_Hypr Mirrored(const gp_Ax1& A1) const;


Standard_EXPORT   void Mirror(const gp_Ax2& A2) ;


//!  Performs the symmetrical transformation of an hyperbola with <br>
//!  respect to a plane. The axis placement A2 locates the plane <br>
//!  of the symmetry (Location, XDirection, YDirection). <br>
Standard_EXPORT   gp_Hypr Mirrored(const gp_Ax2& A2) const;

  void Rotate(const gp_Ax1& A1,const Standard_Real Ang) ;

//!  Rotates an hyperbola. A1 is the axis of the rotation. <br>
//!  Ang is the angular value of the rotation in radians. <br>
  gp_Hypr Rotated(const gp_Ax1& A1,const Standard_Real Ang) const;

  void Scale(const gp_Pnt& P,const Standard_Real S) ;

//!  Scales an hyperbola. S is the scaling value. <br>
  gp_Hypr Scaled(const gp_Pnt& P,const Standard_Real S) const;

  void Transform(const gp_Trsf& T) ;

//!  Transforms an hyperbola with the transformation T from <br>
//!  class Trsf. <br>
  gp_Hypr Transformed(const gp_Trsf& T) const;

  void Translate(const gp_Vec& V) ;

//!  Translates an hyperbola in the direction of the vector V. <br>
//!  The magnitude of the translation is the vector's magnitude. <br>
  gp_Hypr Translated(const gp_Vec& V) const;

  void Translate(const gp_Pnt& P1,const gp_Pnt& P2) ;

//!  Translates an hyperbola from the point P1 to the point P2. <br>
  gp_Hypr Translated(const gp_Pnt& P1,const gp_Pnt& P2) const;
    const gp_Ax2& _CSFDB_Getgp_Hyprpos() const { return pos; }
    Standard_Real _CSFDB_Getgp_HyprmajorRadius() const { return majorRadius; }
    void _CSFDB_Setgp_HyprmajorRadius(const Standard_Real p) { majorRadius = p; }
    Standard_Real _CSFDB_Getgp_HyprminorRadius() const { return minorRadius; }
    void _CSFDB_Setgp_HyprminorRadius(const Standard_Real p) { minorRadius = p; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& gp_Hypr_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Ax2 pos;
Standard_Real majorRadius;
Standard_Real minorRadius;


};


#include <gp_Hypr.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
