// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_Uzawa_HeaderFile
#define _math_Uzawa_HeaderFile

#ifndef _math_Vector_HeaderFile
#include <math_Vector.hxx>
#endif
#ifndef _math_Matrix_HeaderFile
#include <math_Matrix.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class Standard_ConstructionError;
class math_Matrix;
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements a system resolution C*X = B with <br>
//!          an approach solution X0. There are no conditions on the <br>
//!          number of equations. The algorithm used is the Uzawa <br>
//!          algorithm. It is possible to have equal or inequal  (<) <br>
//!          equations to solve. The resolution is done with a <br>
//!          minimization of Norm(X-X0). <br>
//!          If there are only equal equations, the resolution is directly <br>
//!          done and is similar to Gauss resolution with an optimisation <br>
//!          because the matrix is a symmetric matrix. <br>
//!          (The resolution is done with Crout algorithm) <br>
class math_Uzawa  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Given an input matrix Cont, two input vectors Secont <br>
//!          and StartingPoint, it solves Cont*X = Secont (only <br>
//!          = equations) with a minimization of Norme(X-X0). <br>
//!          The maximun iterations number allowed is fixed to <br>
//!          NbIterations. <br>
//!          The tolerance EpsLic is fixed for the dual variable <br>
//!          convergence. The tolerance EpsLix is used for the <br>
//!          convergence of X. <br>
//!          Exception ConstuctionError is raised if the line number <br>
//!          of Cont is different from the length of Secont. <br>
Standard_EXPORT math_Uzawa(const math_Matrix& Cont,const math_Vector& Secont,const math_Vector& StartingPoint,const Standard_Real EpsLix = 1.0e-06,const Standard_Real EpsLic = 1.0e-06,const Standard_Integer NbIterations = 500);

//! Given an input matrix Cont, two input vectors Secont <br>
//!          and StartingPoint, it solves Cont*X = Secont (the Nce <br>
//!          first equations are equal equations and the Nci last <br>
//!          equations are inequalities <) with a minimization <br>
//!          of Norme(X-X0). <br>
//!          The maximun iterations number allowed is fixed to <br>
//!          NbIterations. <br>
//!          The tolerance EpsLic is fixed for the dual variable <br>
//!          convergence. The tolerance EpsLix is used for the <br>
//!          convergence of X. <br>
//!          There are no conditions on Nce and Nci. <br>
//!          Exception ConstuctionError is raised if the line number <br>
//!          of Cont is different from the length of Secont and from <br>
//!          Nce + Nci. <br>
Standard_EXPORT math_Uzawa(const math_Matrix& Cont,const math_Vector& Secont,const math_Vector& StartingPoint,const Standard_Integer Nci,const Standard_Integer Nce,const Standard_Real EpsLix = 1.0e-06,const Standard_Real EpsLic = 1.0e-06,const Standard_Integer NbIterations = 500);
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;
//! Returns the vector solution of the system above. <br>
//!          An exception is raised if NotDone. <br>
 const math_Vector& Value() const;
//! Returns the initial error Cont*StartingPoint-Secont. <br>
//!          An exception is raised if NotDone. <br>
 const math_Vector& InitialError() const;

//! returns the duale variables V of the systeme. <br>
Standard_EXPORT   void Duale(math_Vector& V) const;
//! Returns the difference between X solution and the <br>
//!          StartingPoint. <br>
//!          An exception is raised if NotDone. <br>
 const math_Vector& Error() const;
//! returns the number of iterations really done. <br>
//!          An exception is raised if NotDone. <br>
  Standard_Integer NbIterations() const;
//! returns the inverse matrix of (C * Transposed(C)). <br>
//!          This result is needed for the computation of the gradient <br>
//!          when approximating a curve. <br>
 const math_Matrix& InverseCont() const;

//! Prints information on the current state of the object. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 

//! Is used internally by the two constructors above. <br>
Standard_EXPORT   void Perform(const math_Matrix& Cont,const math_Vector& Secont,const math_Vector& StartingPoint,const Standard_Integer Nci,const Standard_Integer Nce,const Standard_Real EpsLix = 1.0e-06,const Standard_Real EpsLic = 1.0e-06,const Standard_Integer NbIterations = 500) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
math_Vector Resul;
math_Vector Erruza;
math_Vector Errinit;
math_Vector Vardua;
math_Matrix CTCinv;
Standard_Integer NbIter;
Standard_Boolean Done;


};


#include <math_Uzawa.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
