// File:	BSplCLib_BzSyntaxes.cxx
// Created:	Fri Sep  8 16:23:47 1995
// Author:	Laurent BOURESCHE
//		<lbo@phylox>

#include <BSplCLib.hxx>
#include <TColStd_Array1OfInteger.hxx>
#include <TColStd_Array1OfReal.hxx>

#define No_Standard_RangeError
#define No_Standard_OutOfRange

// static Arrays for Bezier computation
static TColStd_Array1OfReal    bidknots(1,2);
static TColStd_Array1OfInteger bidmults(1,2);

//=======================================================================
//function : IncreaseDegree
//purpose  : 
//=======================================================================

void BSplCLib::IncreaseDegree(const Standard_Integer      NewDegree, 
			      const TColgp_Array1OfPnt&   Poles, 
			      const TColStd_Array1OfReal& Weights, 
			      TColgp_Array1OfPnt&         NewPoles, 
			      TColStd_Array1OfReal&       NewWeights)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::IncreaseDegree(deg, NewDegree, 0,
			   Poles, Weights, bidknots, bidmults,
			   NewPoles, NewWeights, bidknots, bidmults);
}

//=======================================================================
//function : IncreaseDegree
//purpose  : 
//=======================================================================

void BSplCLib::IncreaseDegree(const Standard_Integer      NewDegree, 
			      const TColgp_Array1OfPnt2d& Poles, 
			      const TColStd_Array1OfReal& Weights, 
			      TColgp_Array1OfPnt2d&       NewPoles, 
			      TColStd_Array1OfReal&       NewWeights)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::IncreaseDegree(deg, NewDegree, 0,
			   Poles, Weights, bidknots, bidmults,
			   NewPoles, NewWeights, bidknots, bidmults);
}

//=======================================================================
//function : PolesCoefficients
//purpose  : 
//=======================================================================

void BSplCLib::PolesCoefficients(const TColgp_Array1OfPnt&   Poles, 
				 const TColStd_Array1OfReal& Weights, 
				 TColgp_Array1OfPnt&         CachePoles, 
				 TColStd_Array1OfReal&       CacheWeights)
{
  Standard_Integer deg  = Poles.Length() - 1;
  Standard_Integer deg1 = deg + 1;
  TColStd_Array1OfReal bidflatknots(1,deg1 << 1);

  for (Standard_Integer i = 1; i <= deg1; i++){
    bidflatknots(i       ) = 0.;
    bidflatknots(i + deg1) = 1.;
  }
  BSplCLib::BuildCache(0.,1.,0,deg,bidflatknots,
		       Poles, Weights, CachePoles,CacheWeights);
}

//=======================================================================
//function : PolesCoefficients
//purpose  : 
//=======================================================================

void BSplCLib::PolesCoefficients(const TColgp_Array1OfPnt2d& Poles, 
				 const TColStd_Array1OfReal& Weights, 
				 TColgp_Array1OfPnt2d&       CachePoles, 
				 TColStd_Array1OfReal&       CacheWeights)
{
  Standard_Integer deg  = Poles.Length() - 1;
  Standard_Integer deg1 = deg + 1;
  TColStd_Array1OfReal bidflatknots(1,deg1 << 1);

  for (Standard_Integer i = 1; i <= deg1; i++){
    bidflatknots(i       ) = 0.;
    bidflatknots(i + deg1) = 1.;
  }
  BSplCLib::BuildCache(0.,1.,0,deg,bidflatknots,
		       Poles, Weights, CachePoles,CacheWeights);
}

//=======================================================================
//function : D0
//purpose  : 
//=======================================================================

void BSplCLib::D0(const Standard_Real         U,
		  const TColgp_Array1OfPnt&   Poles, 
		  const TColStd_Array1OfReal& Weights,
		  gp_Pnt&                     P)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::D0(U, 1, deg, 0, Poles, Weights, bidknots, bidmults, P);
}

//=======================================================================
//function : D0
//purpose  : 
//=======================================================================

void BSplCLib::D0(const Standard_Real         U,
		  const TColgp_Array1OfPnt2d& Poles, 
		  const TColStd_Array1OfReal& Weights,
		  gp_Pnt2d&                   P)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::D0(U, 1, deg, 0, Poles, Weights, bidknots, bidmults, P);
}

//=======================================================================
//function : D1
//purpose  : 
//=======================================================================

void BSplCLib::D1(const Standard_Real         U,
		  const TColgp_Array1OfPnt&   Poles, 
		  const TColStd_Array1OfReal& Weights,
		  gp_Pnt&                     P,
		  gp_Vec&                     V)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::D1(U, 1, deg, 0, Poles, Weights, bidknots, bidmults, P, V);
}

//=======================================================================
//function : D1
//purpose  : 
//=======================================================================

void BSplCLib::D1(const Standard_Real         U,
		  const TColgp_Array1OfPnt2d& Poles, 
		  const TColStd_Array1OfReal& Weights,
		  gp_Pnt2d&                   P,
		  gp_Vec2d&                   V)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::D1(U, 1, deg, 0, Poles, Weights, bidknots, bidmults, P, V);
}


//=======================================================================
//function : D2
//purpose  : 
//=======================================================================

void BSplCLib::D2(const Standard_Real         U,
		  const TColgp_Array1OfPnt&   Poles, 
		  const TColStd_Array1OfReal& Weights,
		  gp_Pnt&                     P,
		  gp_Vec&                     V1,
		  gp_Vec&                     V2)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::D2(U, 1, deg, 0, Poles, Weights, bidknots, bidmults, P, V1, V2);
}

//=======================================================================
//function : D2
//purpose  : 
//=======================================================================

void BSplCLib::D2(const Standard_Real         U,
		  const TColgp_Array1OfPnt2d& Poles, 
		  const TColStd_Array1OfReal& Weights,
		  gp_Pnt2d&                   P,
		  gp_Vec2d&                   V1,
		  gp_Vec2d&                   V2)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::D2(U, 1, deg, 0, Poles, Weights, bidknots, bidmults, P, V1, V2);
}


//=======================================================================
//function : D3
//purpose  : 
//=======================================================================

void BSplCLib::D3(const Standard_Real         U,
		  const TColgp_Array1OfPnt&   Poles, 
		  const TColStd_Array1OfReal& Weights,
		  gp_Pnt&                     P,
		  gp_Vec&                     V1,
		  gp_Vec&                     V2,
		  gp_Vec&                     V3)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::D3(U, 1, deg, 0, Poles, Weights, bidknots, bidmults, 
	       P, V1, V2, V3);
}

//=======================================================================
//function : D3
//purpose  : 
//=======================================================================

void BSplCLib::D3(const Standard_Real         U,
		  const TColgp_Array1OfPnt2d& Poles, 
		  const TColStd_Array1OfReal& Weights,
		  gp_Pnt2d&                   P,
		  gp_Vec2d&                   V1,
		  gp_Vec2d&                   V2,
		  gp_Vec2d&                   V3)
{
  Standard_Integer deg = Poles.Length() - 1;
  bidmults(1) = bidmults(2) = deg + 1;
  bidknots(1) = 0.; bidknots(2) = 1.;
  BSplCLib::D3(U, 1, deg, 0, Poles, Weights, bidknots, bidmults, 
	       P, V1, V2, V3);
}

