// File:	StepToGeom_MakeSurfaceOfLinearExtrusion.cxx
// Created:	Mon Jul  5 10:04:34 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 23.10.2001. CTS23496: Surface is not created if extrusion axis have not been succesfully created (StepToGeom_MakeSurfaceOfLinearExtrusion(...) function)

#include <StepToGeom_MakeSurfaceOfLinearExtrusion.ixx>
#include <StepGeom_SurfaceOfLinearExtrusion.hxx>
#include <Geom_SurfaceOfLinearExtrusion.hxx>
#include <Geom_VectorWithMagnitude.hxx>
#include <StepToGeom_MakeVectorWithMagnitude.hxx>
#include <Geom_Curve.hxx>
#include <StepToGeom_MakeCurve.hxx>
#include <gp_Vec.hxx>
#include <gp_Dir.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' une SurfaceOfLinearExtrusion de Geom a partir d' une
// SurfaceOfLinearExtrusion de Step
//=============================================================================

StepToGeom_MakeSurfaceOfLinearExtrusion::StepToGeom_MakeSurfaceOfLinearExtrusion
  ( const Handle(StepGeom_SurfaceOfLinearExtrusion)& S)
{

  Handle(StepGeom_Curve)           C;
  Handle(Geom_Curve)               C1;
  Handle(StepGeom_Vector)          V;
  Handle(Geom_VectorWithMagnitude) V1;
  gp_Vec                           V2;
  gp_Dir                           D;

  C  = S->SweptCurve();
  StepToGeom_MakeCurve MkCurve(C);
  C1 = MkCurve.Value();
  V  = S->ExtrusionAxis();
  StepToGeom_MakeVectorWithMagnitude MkVector(V);
  // sln 23.10.2001. CTS23496: Surface is not created if extrusion axis have not been succesfully created
   if(!MkVector.IsDone()) {
    done = Standard_False;
    return;
  }
  V1 = MkVector.Value();
  V2 = V1->Vec();
  D  = gp_Dir(V2);
  theSurfaceOfLinearExtrusion = new Geom_SurfaceOfLinearExtrusion(C1, D);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_SurfaceOfLinearExtrusion) &
      StepToGeom_MakeSurfaceOfLinearExtrusion::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theSurfaceOfLinearExtrusion;
}
