// File:	StepToGeom_MakeSweptSurface.cxx
// Created:	Mon Jul  5 10:52:45 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
//:p0 abv 19.02.99: management of 'done' flag improved

#include <StepToGeom_MakeSweptSurface.ixx>
#include <StdFail_NotDone.hxx>
#include <StepGeom_SweptSurface.hxx>
#include <StepToGeom_MakeSweptSurface.hxx>
#include <StepGeom_SurfaceOfLinearExtrusion.hxx>
#include <StepGeom_SurfaceOfRevolution.hxx>
#include <StepToGeom_MakeSurfaceOfLinearExtrusion.hxx>
#include <StepToGeom_MakeSurfaceOfRevolution.hxx>

//=============================================================================
// Creation d' une SweptSurface de prostep a partir d' une 
// SweptSurface de Geom
//=============================================================================

StepToGeom_MakeSweptSurface::StepToGeom_MakeSweptSurface
  ( const Handle(StepGeom_SweptSurface)& S)
{
  done = Standard_False;
  if (S->IsKind(STANDARD_TYPE(StepGeom_SurfaceOfLinearExtrusion))) {
    Handle(StepGeom_SurfaceOfLinearExtrusion) Sur = 
      Handle(StepGeom_SurfaceOfLinearExtrusion)::DownCast(S);
    StepToGeom_MakeSurfaceOfLinearExtrusion MkExtrusion(Sur);
    if ( MkExtrusion.IsDone() ) theSweptSurface = MkExtrusion.Value();
  }
  else if (S->IsKind(STANDARD_TYPE(StepGeom_SurfaceOfRevolution))) {
    Handle(StepGeom_SurfaceOfRevolution) Sur = 
      Handle(StepGeom_SurfaceOfRevolution)::DownCast(S);
    StepToGeom_MakeSurfaceOfRevolution MkRevol(Sur);
    if ( MkRevol.IsDone() ) theSweptSurface = MkRevol.Value();
  }
  done = ! theSweptSurface.IsNull();
}	 

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_SweptSurface) &
      StepToGeom_MakeSweptSurface::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theSweptSurface;
}
