// 2DSelectionDoc.cpp : implementation of the C2DSelectionDoc class
//

#include "stdafx.h"

#include "2DSelectionDoc.h"

#include "2DSelectionApp.h"
#include "Sample2D_Text.h"
#include "Sample2D_Rectangle.h"
#include "Aspect_ColorMap.hxx"

/////////////////////////////////////////////////////////////////////////////
// C2DSelectionDoc

IMPLEMENT_DYNCREATE(C2DSelectionDoc, CDocument)

BEGIN_MESSAGE_MAP(C2DSelectionDoc, CDocument)
	//{{AFX_MSG_MAP(C2DSelectionDoc)
	ON_COMMAND(ID_BUTTON_Test_Text, OnBUTTONTestText)
	ON_COMMAND(ID_BUTTON_Test_Rect, OnBUTTONTestRect)
	ON_COMMAND(ID_BUTTON_Erase, OnBUTTONErase)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C2DSelectionDoc construction/destruction

C2DSelectionDoc::C2DSelectionDoc()
{
}

C2DSelectionDoc::~C2DSelectionDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// C2DSelectionDoc diagnostics

#ifdef _DEBUG
void C2DSelectionDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void C2DSelectionDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

void C2DSelectionDoc::OnBUTTONErase() 
{
   myAISInteractiveContext2D->EraseAll();
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Erase;
  TCollection_AsciiString Message("\
call :    \n\
   myAISInteractiveContext2D->EraseAll();\n\
-------------------------------------------------------------------------------- \n");

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}




void C2DSelectionDoc::OnBUTTONTestText() 
{
 Standard_Integer color=1;
 for (Standard_Real j=15;j<=20;j++)
  {
    TCollection_AsciiString Text("font 0 scale ");Text+=j/20;
    Handle (Sample2D_Text) aText  = new Sample2D_Text(
		               Text,
                       0,15*(j-15),      //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       20.0*PI180 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,               //  aColorIndex  
                       0,               //  aFontIndex  
                       j/20,                //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_False,   // aIsZoomable
                       Graphic2d_TOA_LEFT); // aTypeOfAlignment

	aText->SetHighlightMode(AIS2D_TOD_OBJECT);
    myAISInteractiveContext2D->Display(aText);  // Draw text

    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }

  for (j=5;j<=10;j+=1)
  {
    TCollection_AsciiString Text("font 1 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText  = new Sample2D_Text(
		               Text,
                       80,15*(j-5),  //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0.0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,         //  aColorIndex  
                       1,               //  aFontIndex  
                       j/10,                //  aScale 
                       Standard_True,  // aIsUnderline
                       Standard_True,   // aIsZoomable
                       Graphic2d_TOA_CENTER); // aTypeOfAlignment

	aText->SetHighlightMode(AIS2D_TOD_OBJECT);
	myAISInteractiveContext2D->Display(aText);  // Draw text

    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }
    
  for (j=5;j<=10;j+=1)
  {
    TCollection_AsciiString Text("font 2 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText  = new Sample2D_Text(
		               Text,
                       140,15*(j-5),  //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0.0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,         //  aColorIndex  
                       2,               //  aFontIndex  
                       j/10,               //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_True,   // aIsZoomable
                       Graphic2d_TOA_TOPLEFT); // aTypeOfAlignment

	aText->SetHighlightMode(AIS2D_TOD_OBJECT);
    myAISInteractiveContext2D->Display(aText);  // Draw text

    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }
    
  for (j=10;j<=15;j+=1)
  {
    TCollection_AsciiString Text("font 3 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText  = new Sample2D_Text(
		               Text,
                       260,15*(j-10),      //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,               //  aColorIndex  
                       3,               //  aFontIndex  
                       j/10,                //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_False,   // aIsZoomable
                       Graphic2d_TOA_LEFT); // aTypeOfAlignment

	aText->SetHighlightMode(AIS2D_TOD_OBJECT);
	myAISInteractiveContext2D->Display(aText);  // Draw text

    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }

  FitAll2DViews(Standard_True); // Update Viewer
  // Update Get information to update Result dialog
  UINT anID=ID_BUTTON_Test_Text;
  TCollection_AsciiString Message("  \
create a set of Sample2D_Text and display it:    \n\
------------------------------------------------------------------------------ \n\
    Handle (Sample2D_Text) aText;                          \n\
    // aText = new ...                                            \n\
   \n\
   aText->SetHighlightMode(AIS2D_TOD_OBJECT); //Set selection of the Sample2D_Text\n\
   myInteractiveContext2D->Display(aTex);  // Redraw       \n\
------------------------------------------------------------------------------ \n\
   after on WM_MOUSEMOVE event call a method MoveTo of AIS2D_InteractiveContext  \n\
   and on WM_LBUTTONUP enent call a method Select of AIS2D_InteractiveContext\n\
------------------------------------------------------------------------------ \n\
                                                                  \n\n");


  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}

void C2DSelectionDoc::OnBUTTONTestRect() 
{

  
   Handle (Sample2D_Rectangle) aRectangle = new Sample2D_Rectangle(
	                                         0,0,       // display point
                                             50,80,     // size
                                             20*PI180); // angle in radian

   aRectangle->SetHighlightMode(AIS2D_TOD_OBJECT);
   myAISInteractiveContext2D->Display(aRectangle, Standard_False);  // Display rectangle
  

 
   Handle (Sample2D_Rectangle) aRectangle2 = new Sample2D_Rectangle(
	                                       80,0,       // display point
                                           50,90,     // size
                                           20*PI180); // angle in radian

   aRectangle2->SetHighlightMode(AIS2D_TOD_ELEMENT);
   myAISInteractiveContext2D->Display(aRectangle2);  // Display rectangle
  

   FitAll2DViews(Standard_False); // Update Viewer

  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Test_Rect;
  TCollection_AsciiString Message(" \
create a two of Sample2D_Rectangle and display it :    \n\
------------------------------------------------------------------------------ \n\
  {                                                                    \n\
   Handle (Sample2D_Rectangle) aRectangle  =                   \n\
        new Sample2D_Rectangle(0,0,       // display point \n\
                                             50,80,     // size              \n\
                                             20*PI180); // angle in radian  \n\
\n\
   aRectangle->SetHighlightMode(AIS2D_TOD_OBJECT); \n\
   myASIInteractiveContext2D->Display(aRectangle, Standard_False);  // Display rectangle  \n\
  }                                                              \n\
  {                                                                 \n\
  Handle (Sample2D_Rectangle) aRectangle  =  \n\
        new Sample2D_Rectangle(80,0,       // display point \n\
                                             50,90,     // size  \n\
                                             20*PI180); // angle in radian \n\
\n\
  aRectangle2->SetHighlightMode(AIS2D_TOD_ELEMENT);  //Set selection sub elements    \n\
  myAISInteractiveContext2D->Display(aRectangle);  // Dispaly rectangle    \n\
  }\n\
  FitAll2DViews(Standard_False); // Update Viewer\n\
\n\
---------------------------------------------------------------- \n\
   after that the system call the SetContext Methods :                    \n\
---------------------------------------------------------------- \n\
void Sample2D_Rectangle::SetContext(const Handle(AIS2D_InteractiveContext)& theContext) \n\
{\n\
\n\
  AIS2D_InteractiveObject::SetContext(theContext); \n\
\n\
  // add the polyline in the representation, for all modes\n\
  Handle(Graphic2d_Polyline) ThePolyline;\n\
  ThePolyline = new Graphic2d_Polyline(this,myArray1OfVertex );\n\
  ThePolyline->SetColorIndex ( 1 );\n\
  ThePolyline->SetWidthIndex ( 1 );\n\
  ThePolyline->SetTypeIndex  ( 1 );\n\
\n");
Message+= "\
------------------------------------------------------------------------------ \n\
   after on WM_MOUSEMOVE event call a method MoveTo of AIS2D_InteractiveContext  \n\
   and on WM_LBUTTONUP enent call a method Select of AIS2D_InteractiveContext\n\
------------------------------------------------------------------------------";

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}






