// $Id: Rom8kBBlocks.hh,v 1.8 2004/12/15 09:09:48 m9710797 Exp $

#ifndef __ROM8KBBLOCKS_HH__
#define __ROM8KBBLOCKS_HH__

#include "MSXRom.hh"

namespace openmsx {

class Rom8kBBlocks : public MSXRom
{
public:
	virtual byte readMem(word address, const EmuTime& time);
	virtual const byte* getReadCacheLine(word start) const;

protected:
	Rom8kBBlocks(const XMLElement& config, const EmuTime& time,
	             std::auto_ptr<Rom> rom);
	virtual ~Rom8kBBlocks();

	void setBank(byte region, byte* adr);
	void setRom(byte region, int block);

	byte* bank[8];
};

} // namespace openmsx

#endif
