/*
**  InternetAddress.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
#include <Pantomime/InternetAddress.h>

#include <Pantomime/Constants.h>
#include <Pantomime/MimeUtility.h>
#include <Pantomime/NSString+Extensions.h>

#include <Pantomime/elm_defs.h>

#include <Foundation/NSValue.h>

@implementation InternetAddress : NSObject

- (id) init
{
  self = [super init];
  
  return self;
}

- (id) initWithString: (NSString *) theString
{
  char abuf[128], nbuf[128], *cf, *nf;
  int rc;
  
  self = [self init];
  
  cf = (char*)[theString cString];
  
  rc = parse_arpa_mailbox(cf, abuf, sizeof(abuf), nbuf, sizeof(nbuf), &nf);
  
  if (rc < 0)
    {
      [self setPersonal: theString];
      return self;
    }

  [self setPersonal: [NSString stringWithCString: nbuf]];
  [self setAddress: [NSString stringWithCString: abuf]];

  return self;
}

- (id) initWithPersonal: (NSString *) thePersonal
             andAddress: (NSString *) theAddress
{
  self = [self init];
  
  [self setPersonal: thePersonal];
  [self setAddress: theAddress];

  return self;
}

- (void) dealloc
{
  RELEASE(address);
  RELEASE(personal);

  [super dealloc];
}

- (NSString *) address
{
  return address;
}

- (void) setAddress: (NSString *) theAddress
{
  if ( theAddress )
    {
      RETAIN(theAddress);
      RELEASE(address);
      address = theAddress;
    }
  else
    {
      RELEASE(address);
      address = nil;
    }
}

- (NSString *) personal
{
  // We verify if we need to quote the personal
  NSString *aString;
  
  if ( [personal indexOfCharacter: ','] > 0 &&
       ![personal hasPrefix: @"\""] &&
       ![personal hasSuffix: @"\""] )
    {
      aString = [NSString stringWithFormat: @"\"%@\"", personal];
    }
  else
    {
      aString = personal;
    }
  
  return aString;
}

- (void) setPersonal: (NSString *) thePersonal
{
  if ( thePersonal )
    {
      RELEASE(personal);
      RETAIN(thePersonal);
      personal = thePersonal;
    }
  else
    {
      RELEASE(personal);
      personal = nil;
    }
}

- (int) type 
{
  return type;
}

- (void) setType: (int) theType
{
  type = theType;
}

- (NSData *) dataValue
{
  if ([self personal] && [[self personal] length] > 0)
    {
      NSMutableData *aMutableData;

      aMutableData = [[NSMutableData alloc] init];

      [aMutableData appendData: [MimeUtility encodeWordUsingQuotedPrintable: [self personal] prefixLength: 0]];
      if ([self address])
	{
	  [aMutableData appendBytes: " <"  length: 2];
	  [aMutableData appendData: [[self address] dataUsingEncoding: NSASCIIStringEncoding]];
	  [aMutableData appendBytes: ">" length: 1];
	}

      return AUTORELEASE(aMutableData);
    }
  else
    {
      return [[self address] dataUsingEncoding: NSASCIIStringEncoding];
    }
}

- (NSString *) unicodeStringValue
{
  if ([self personal] && [[self personal] length] > 0)
    {
      if ([self address])
	{
	  return [NSString stringWithFormat:@"%@ <%@>",
		       [self personal], 
		       [self address]];
	}
      else
	{
	  return [NSString stringWithFormat:@"%@",[self personal]];
	}
    }
  else
    {
      return [self address];
    }
}

//
// NSCoding protocol
//

- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: [NSNumber numberWithInt: [self type]]];
  [theCoder encodeObject: [self address]];
  [theCoder encodeObject: [self personal]];
}

- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super init];

  [self setType: [[theCoder decodeObject] intValue]];
  [self setAddress: [theCoder decodeObject]];
  [self setPersonal: [theCoder decodeObject]];

  return self;
}

// For scripting support 
- (id) container
{
    return (container);
}
- (void) setContainer: (id) aContainer
{
    container = aContainer;
}


@end


@implementation ToRecipient

- (id) init
{
    self = [super init];
    [self setType: TO];
    return (self);
}

@end

@implementation CcRecipient

- (id) init
{
    self = [super init];
    [self setType: CC];
    return (self);
}

@end

@implementation BccRecipient

- (id) init
{
    self = [super init];
    [self setType: BCC];
    return (self);
}

@end


