#ifndef INCLUDE_CONFIGFILE_H
#define INCLUDE_CONFIGFILE_H
/* ----------------------------------------------------------------------------
 * configfile.h
 * prototypes and definitions for configfile.c.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <stdio.h>
#include <pbbtaglist.h>

struct cftitem {
  int  section;
  char *configtag;
  long tag1;
  long tag2;
  void (*read)();
  void (*write)();
  char *comment;
};

/* public prototypes */
struct tagitem * read_configfile (char *configfile);
void write_configfile (char *configfile);

/* private prototypes */
void cft_read_string (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_string (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_key (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_key (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_bool (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_bool (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_invbool (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_invbool (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_int (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_int (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_tpmode (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_tpmode (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_kbdmode (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_kbdmode (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_batlogmode (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_batlogmode (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_ema (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_ema (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_policy (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_policy (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
void cft_read_action (struct cftitem *citem, struct tagitem **taglist, char **strptr, char *arg);
void cft_write_action (FILE *fd, struct cftitem *citem, struct tagitem *taglist);
int read_label(char *label, char *names[], int cnt);
void decode_key_and_modifier(char *arg, int *key, int *mod);
char* code_key_and_modifier (int key, int mod);

#endif    /* INCLUDE_CONFIGFILE_H */

