/******************************************************
 *
 * triggerize - implementation file
 *
 * copyleft (c) IOhannes m zmölnig
 *
 *   2016:forum::für::umläute:2016
 *
 *   institute of electronic music and acoustics (iem)
 *
 ******************************************************
 *
 * license: GNU General Public License v.2 (or later)
 *
 ******************************************************/

#include "m_pd.h"

#include "g_canvas.h"
#include "m_imp.h"

#define MARK() post("%s:%d\t%s", __FILE__, __LINE__, __FUNCTION__)

/* ------------ utilities ---------- */
static t_gobj*o2g(t_object*obj) {
  return &(obj->te_g);
}
static t_object*g2o(t_gobj*gobj) {
  return pd_checkobject(&gobj->g_pd);
}
t_gobj*glist_getlast(t_glist*cnv) {
  t_gobj*result=NULL;
  for(result=cnv->gl_list; result->g_next;) result=result->g_next;
  return result;
}
static void dereconnect(t_glist*cnv, t_object*org, t_object*replace) {
  t_gobj*gobj;
  for(gobj=cnv->gl_list; gobj; gobj=gobj->g_next) {
    t_object*obj=g2o(gobj);
    int obj_nout=0;
    int nout;
    if(!obj)continue;
    obj_nout=obj_noutlets(obj);
    for(nout=0; nout<obj_nout; nout++) {
      t_outlet*out=0;
      t_outconnect*conn=obj_starttraverseoutlet(obj, &out, nout);
      while(conn) {
        int which;
        t_object*dest=0;
        t_inlet *in =0;
        conn=obj_nexttraverseoutlet(conn, &dest, &in, &which);
        if(dest!=org)
          continue;
        obj_disconnect(obj, nout, dest, which);
        obj_connect(obj, nout, replace, which);
      }
    }
  }
}
static t_object*triggerize_createobj(t_glist*x, t_binbuf*b) {
  t_pd *boundx = s__X.s_thing, *boundn = s__N.s_thing;
  s__X.s_thing = &x->gl_pd;
  s__N.s_thing = &pd_canvasmaker;

  binbuf_eval(b, 0, 0, 0);

  s__X.s_thing = boundx;
  s__N.s_thing = boundn;
  return g2o(glist_getlast(x));
}
static void stack_conn(t_object*new, int*newoutlet, t_object*org, int orgoutlet, t_outconnect*conn){
  t_object*dest=0;
  t_inlet *in =0;
  int which;

  conn=obj_nexttraverseoutlet(conn, &dest, &in, &which);
  if(conn)
    stack_conn(new, newoutlet, org, orgoutlet, conn);
  obj_disconnect(org, orgoutlet, dest, which);
  obj_connect(new, *newoutlet, dest, which);
  (*newoutlet)++;
}
static int has_fanout(t_object*obj) {
  int obj_nout=obj_noutlets(obj);
  int nout;
  /* check if we actually do have a fan out */
  for(nout=0; nout<obj_nout; nout++) {
    t_outlet*out=0;
    t_outconnect*conn=obj_starttraverseoutlet(obj, &out, nout);
    int count=0;
    if(obj_issignaloutlet(obj, nout))
      continue;
    while(conn) {
      int which;
      t_object*dest=0;
      t_inlet *in =0;
      if(count)return 1;
      conn=obj_nexttraverseoutlet(conn, &dest, &in, &which);
      count++;
    }
  }
  return 0;
}
/* ------------------------- triggerize ---------------------------- */
static int triggerize_fanout_inplace(t_glist*x, t_object*obj) {
  int posX=obj->te_xpix;
  int posY=obj->te_ypix;
  t_atom*argv=binbuf_getvec(obj->te_binbuf);
  int    argc=binbuf_getnatom(obj->te_binbuf);
  int obj_nout=obj_noutlets(obj);
  int nout, newout;
  t_binbuf*b=0;
  t_object*stub=0;

  /* avoid fanouts in [t] objects by adding additional outlets */

  /* check if we actually do have a fan out */
  if(!has_fanout(obj))return 0;

  /* create a new trigger object, that hsa outlets for the fans */
  b=binbuf_new();
  binbuf_addv(b, "ssii", gensym("#X"), gensym("obj"), posX, posY);
  binbuf_add(b, 1, argv);
  argc--; argv++;
  for(nout=0; nout<obj_nout; nout++) {
    t_outlet*out=0;
    t_outconnect*conn=obj_starttraverseoutlet(obj, &out, nout);
    while(conn) {
      int which;
      t_object*dest=0;
      t_inlet *in =0;
      conn=obj_nexttraverseoutlet(conn, &dest, &in, &which);
      binbuf_add(b, 1, argv);
    }
    argv++; argc--;
  }
  binbuf_addsemi(b);
  stub=triggerize_createobj(x, b);
  binbuf_free(b);

  /* connect */
  newout=0;
  dereconnect(x, obj, stub);
  for(nout=0; nout<obj_nout; nout++) {
    t_outlet*out=0;
    t_outconnect*conn=obj_starttraverseoutlet(obj, &out, nout);
    stack_conn(stub, &newout, obj, nout, conn);
  }

  /* free old object */
  glist_delete(x, o2g(obj));
  return 1;
}
static int triggerize_fanout(t_glist*x, t_object*obj, int fanout_trigger_inplace) {
  const t_symbol*s_trigger=gensym("trigger");
  int obj_nout=obj_noutlets(obj);
  int nout;
  int posX=obj->te_xpix-10;
  int posY=obj->te_ypix+20;
  t_binbuf*b=binbuf_new();
  int didit=0;
  if(fanout_trigger_inplace && (s_trigger == obj->te_g.g_pd->c_name)) {
    return triggerize_fanout_inplace(x, obj);
  }

  for(nout=0; nout<obj_nout; nout++) {
    t_outlet*out=0;
    t_outconnect*conn=obj_starttraverseoutlet(obj, &out, nout);
    int count=0;
    if(obj_issignaloutlet(obj, nout))
      continue;
    while(conn) {
      int which;
      t_object*dest=0;
      t_inlet *in =0;
      conn=obj_nexttraverseoutlet(conn, &dest, &in, &which);
      count++;
    }
    if(count>1) {
      /* fan out */
      int i;
      t_object*stub=0;
      binbuf_clear(b);
      binbuf_addv(b, "ssiis", gensym("#X"), gensym("obj"), posX, posY, gensym("t"));
      for(i=0; i<count; i++) {
        binbuf_addv(b, "s", gensym("a"));
      }
      binbuf_addsemi(b);
      stub=triggerize_createobj(x, b);
      conn=obj_starttraverseoutlet(obj, &out, nout);
      i=0;
      while(conn) {
        int which;
        t_object*dest=0;
        t_inlet *in =0;
        conn=obj_nexttraverseoutlet(conn, &dest, &in, &which);
        obj_disconnect(obj, nout, dest, which);
        obj_connect(stub, count-i-1, dest, which);
        i++;
      }
      obj_connect(obj, nout, stub, 0);
      glist_select(x, o2g(stub));
    }
    didit++;
  }
  binbuf_free(b);
  return didit;
}
static int triggerize_fanouts(t_glist*cnv, int fanout_trigger_inplace) {
  t_gobj*gobj = NULL;
  int count=0;
  for(gobj=cnv->gl_list; gobj; gobj=gobj->g_next) {
    t_object*obj=g2o(gobj);
    if(obj && glist_isselected(cnv, gobj) && triggerize_fanout(cnv, obj, fanout_trigger_inplace))
      count++;
  }
  return count;
}

static int triggerize_line(t_glist*x) {
  t_editor*ed=x->gl_editor;
  int src_obj, src_out, dst_obj ,dst_in;
  t_gobj *src = 0, *dst = 0;
  t_binbuf*b=0;
  int posx=100, posy=100;
  t_object*stub=0;

  if(!ed->e_selectedline)
    return 0;
  src_obj=ed->e_selectline_index1;
  src_out=ed->e_selectline_outno;
  dst_obj=ed->e_selectline_index2;
  dst_in =ed->e_selectline_inno;
  for (src = x->gl_list; src_obj; src = src->g_next, src_obj--)
    if (!src->g_next) goto bad;
  for (dst = x->gl_list; dst_obj; dst = dst->g_next, dst_obj--)
    if (!dst->g_next) goto bad;
  src_obj=ed->e_selectline_index1;
  dst_obj=ed->e_selectline_index2;

  if(1) {
    t_object*obj1=g2o(src);
    t_object*obj2=g2o(dst);
    if(obj1 && obj2) {
      posx=(obj1->te_xpix+obj2->te_xpix)>>1;
      posy=(obj1->te_ypix+obj2->te_ypix)>>1;
    }
  }

  b=binbuf_new();
  if(obj_issignaloutlet(g2o(src), src_out)) {
    //binbuf_addv(b,"ssii", gensym("#X"), gensym("obj"), posx, posy);
    //binbuf_addv(b,"s", gensym("+~"));235 124 189 224
    binbuf_addv(b, "ssiiiisi;", gensym("#N"), gensym("canvas"), 200, 100, 190, 200, gensym("nop~"), 0);
    binbuf_addv(b, "ssiis;", gensym("#X"), gensym("obj"), 50, 70, gensym("inlet~"));
    binbuf_addv(b, "ssiis;", gensym("#X"), gensym("obj"), 50,140, gensym("outlet~"));
    binbuf_addv(b, "ssiiii;", gensym("#X"), gensym("connect"), 0,0,1,0);
    binbuf_addv(b, "ssiiss", gensym("#X"), gensym("restore"), posx, posy, gensym("pd"), gensym("nop~"));
  } else {
    binbuf_addv(b,"ssii", gensym("#X"), gensym("obj"), posx, posy);
    binbuf_addv(b,"ss", gensym("t"), gensym("a"));
  }
  binbuf_addsemi(b);
  stub=triggerize_createobj(x, b);
  binbuf_free(b);b=0;

  obj_disconnect(g2o(src), src_out, g2o(dst), dst_in);
  obj_connect(g2o(src), src_out, stub, 0);
  obj_connect(stub, 0, g2o(dst), dst_in);
  glist_select(x, o2g(stub));

  return 1;
 bad:
  return 0;
}
static int triggerize_trigger(t_glist*cnv, t_object*obj) {
  /* insert a first "a" outlet into the trigger */
  t_binbuf*b=binbuf_new();
  int argc=binbuf_getnatom(obj->te_binbuf);
  t_atom*argv=binbuf_getvec(obj->te_binbuf);
  t_object*stub=0;
  int obj_nout=obj_noutlets(obj);
  int nout;

  binbuf_addv(b, "ssii", gensym("#X"), gensym("obj"), obj->te_xpix, obj->te_ypix);
  binbuf_add(b, 1, argv);
  binbuf_addv(b, "s", gensym("a"));
  binbuf_add(b, argc-1, argv+1);
  stub=triggerize_createobj(cnv, b);
  for(nout=0; nout<obj_nout; nout++) {
    t_outlet*out=0;
    t_outconnect*conn=obj_starttraverseoutlet(obj, &out, nout);
    while(conn) {
      int which;
      t_object*dest=0;
      t_inlet *in =0;
      conn=obj_nexttraverseoutlet(conn, &dest, &in, &which);
      obj_disconnect(obj, nout, dest, which);
      obj_connect(stub, nout+1, dest, which);
    }
  }
  binbuf_free(b);
  dereconnect(cnv, obj, stub);
  glist_delete(cnv,o2g(obj));
  //glist_select(cnv, o2g(stub));
  return 1;
}
static int triggerize_triggers(t_glist*cnv, int skip_if_nontriggers) {
  t_gobj*gobj = NULL;
  const t_symbol*s_trigger=gensym("trigger");
  int count=0;

  if(skip_if_nontriggers) {
    /* if this is enabled, we refuse to do anything if the selection is not
     * exclusively [trigger] objects
     */
    for(gobj=cnv->gl_list; gobj; gobj=gobj->g_next) {
      t_object*obj=g2o(gobj);
      if(obj && glist_isselected(cnv, gobj) && (s_trigger != obj->te_g.g_pd->c_name)) {
        return 0;
      }
    }
  }
  for(gobj=cnv->gl_list; gobj; gobj=gobj->g_next) {
    t_object*obj=g2o(gobj);
    if(obj && glist_isselected(cnv, gobj)) {
      const t_symbol*c_name=obj->te_g.g_pd->c_name;
      if((s_trigger == c_name)&&triggerize_trigger(cnv, obj))
        count++;
    }
  }
  return count;
}

static void canvas_do_triggerize(t_glist*cnv) {
  /*
   * selected msg-connection: insert [t a]
   * selected sig-connection: insert [pd nop~]
   * selected [trigger]: if fan-outs, remove them
   * selected [trigger]: if no fan-outs, add left-most "a" outlet
   * selected objects: remove fan-outs
   */
  if(triggerize_line(cnv))return;
  if(triggerize_fanouts(cnv, 1))return;
  if(triggerize_triggers(cnv, 1))return;
}
static void canvas_triggerize(t_glist*cnv) {
  int dspstate;
  if(NULL == cnv)return;

  /* suspend system */
  dspstate = canvas_suspend_dsp();

  canvas_do_triggerize(cnv);

  /* restore state */
  canvas_redraw(cnv);
  glist_redraw(cnv);
  canvas_resume_dsp(dspstate);
}

void triggerize_setup(void)
{
  if(NULL==canvas_class)return;
  post("triggerize - insert [trigger] ad lib.");

  if(NULL==zgetfn(&canvas_class, gensym("triggerize")))
    class_addmethod(canvas_class, (t_method)canvas_triggerize, gensym("triggerize"), 0);
}
