/* ---------------------------------------------------------------- */

%wrapper %{
#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
EXTERN_C_BEGIN
EXTERN PetscErrorCode PETSCMAT_DLLEXPORT MatCreate_ISX(Mat A);
EXTERN_C_END
#endif
%}

/* ---------------------------------------------------------------- */

#define PCSCHUR  "schur"

%wrapper %{
#define PCSCHUR  "schur"
EXTERN_C_BEGIN
EXTERN PetscErrorCode PETSCKSP_DLLEXPORT PCCreate_Schur(PC);
EXTERN_C_END
%}

/* ---------------------------------------------------------------- */

#define TS_USER  "user"

%wrapper %{
#define TS_USER  "user"
EXTERN_C_BEGIN
EXTERN PetscErrorCode PETSCTS_DLLEXPORT TSCreate_User(TS);
EXTERN_C_END
%}


/* ---------------------------------------------------------------- */

%wrapper %{
#undef  __FUNCT__  
#define __FUNCT__ "PyPetscRegisterAll"
static PetscErrorCode
PyPetscRegisterAll(const char path[]) {
  PetscErrorCode ierr;
  PetscFunctionBegin;

#if (PETSC_VERSION_MAJOR    == 2 && \
     PETSC_VERSION_MINOR    == 3 && \
     PETSC_VERSION_SUBMINOR == 2 && \
     PETSC_VERSION_RELEASE  == 1)
  /* Mat */
#ifndef PETSC_USE_DYNAMIC_LIBRARIES
  ierr = MatInitializePackage(PETSC_NULL);CHKERRQ(ierr);
#endif
  ierr = MatRegisterDynamic (MATIS,   path, "MatCreate_ISX",  MatCreate_ISX);  CHKERRQ(ierr);
#endif

  /* PC */
#ifndef PETSC_USE_DYNAMIC_LIBRARIES
  ierr = PCInitializePackage(PETSC_NULL);CHKERRQ(ierr);
#endif
  ierr = PCRegisterDynamic  (PCSCHUR, path, "PCCreate_Schur", PCCreate_Schur); CHKERRQ(ierr);

  /* TS */
#ifndef PETSC_USE_DYNAMIC_LIBRARIES
  ierr = TSInitializePackage(PETSC_NULL);CHKERRQ(ierr);
#endif
  ierr = TSRegisterDynamic(TS_USER,   path, "TSCreate_User",  TSCreate_User);CHKERRQ(ierr);

  PetscFunctionReturn(0);
}
%}

/* ---------------------------------------------------------------- */

/*
 * Local Variables:
 * mode: C
 * End:
 */
