  /*  prefs-shortcuts.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "powershell.h"

GtkWidget * keyboxes[28];
GtkWidget * hbox1, * vbox1, * vbox2;
GtkWidget * hboxes[28];

int keys[28], modifiers[28];

void GetKeyText (char * buf, int modifiers, int key)
{
  char * tmp = (char *)malloc (512);
  bzero (tmp, 512);

  strcpy (buf, tmp);

  if (!key)
    return;

  if (modifiers & 1)
    tmp = strcat (tmp, "Shift + ");
  if (modifiers & 4)
    tmp = strcat (tmp, "Control + ");
  if (modifiers & 8)
    tmp = strcat (tmp, "Alt + ");

  tmp = strcat (tmp, gdk_keyval_name (key));

  strcpy (buf, tmp);


  free (tmp);
}

gboolean shortcut_key_event (GtkWidget * widget, GdkEventKey * event, gpointer user_data)
{
  char buf[512];
  GetKeyText (buf, event->state, event->keyval);
 
  gtk_entry_set_text (GTK_ENTRY(keyboxes[(int)user_data]), buf);

  keys[(int)user_data] = event->keyval;
  modifiers[(int)user_data] = event->state;

  event->state = event->keyval = event->length = 0;
  event->string = NULL;

  property_changed (NULL, NULL);
  
  return TRUE;
}



int CreatePrefsShortcuts (GtkContainer * area)
{
  int a;
  char buf[512];
  
  hbox1 = gtk_hbox_new (FALSE, 0);
  
  vbox1 = gtk_vbox_new (TRUE, 0);
  vbox2 = gtk_vbox_new (TRUE, 0);
  
  gtk_box_pack_start (GTK_BOX(area), hbox1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hbox1), vbox1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hbox1), vbox2, FALSE, FALSE, 0);

  hboxes[0] = gtk_hbox_new (TRUE, 0);
  keyboxes[0] = gtk_entry_new ();

  GetKeyText (buf, keyprefs.cycle_forwards.modifiers, keyprefs.cycle_forwards.key);
  gtk_entry_set_text (GTK_ENTRY(keyboxes[0]), buf);

  gtk_box_pack_start (GTK_BOX(vbox1), hboxes[0], FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[0]), gtk_label_new ("Cycle Forwards"), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[0]), keyboxes[0], FALSE, FALSE, 0);


  hboxes[1] = gtk_hbox_new (TRUE, 0);
  keyboxes[1] = gtk_entry_new ();

  GetKeyText (buf, keyprefs.cycle_backwards.modifiers, keyprefs.cycle_backwards.key);
  gtk_entry_set_text (GTK_ENTRY(keyboxes[1]), buf);

  gtk_box_pack_start (GTK_BOX(vbox1), hboxes[1], FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[1]), gtk_label_new ("Cycle Backwards"), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[1]), keyboxes[1], FALSE, FALSE, 0);
  

  hboxes[2] = gtk_hbox_new (TRUE, 0);
  keyboxes[2] = gtk_entry_new ();

  GetKeyText (buf, keyprefs.move_forwards.modifiers, keyprefs.move_forwards.key);
  gtk_entry_set_text (GTK_ENTRY(keyboxes[2]), buf);

  gtk_box_pack_start (GTK_BOX(vbox1), hboxes[2], FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[2]), gtk_label_new ("Move Tab Forwards"), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[2]), keyboxes[2], FALSE, FALSE, 0);
   

  hboxes[3] = gtk_hbox_new (TRUE, 0);
  keyboxes[3] = gtk_entry_new ();

  GetKeyText (buf, keyprefs.move_backwards.modifiers, keyprefs.move_backwards.key);
  gtk_entry_set_text (GTK_ENTRY(keyboxes[3]), buf);

  gtk_box_pack_start (GTK_BOX(vbox1), hboxes[3], FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[3]), gtk_label_new ("Move Tab Backwards"), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[3]), keyboxes[3], FALSE, FALSE, 0);
   




  hboxes[4] = gtk_hbox_new (TRUE, 0);
  keyboxes[4] = gtk_entry_new ();

  GetKeyText (buf, keyprefs.close.modifiers, keyprefs.close.key);
  gtk_entry_set_text (GTK_ENTRY(keyboxes[4]), buf);

  gtk_box_pack_start (GTK_BOX(vbox2), hboxes[4], FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[4]), gtk_label_new ("Close Term"), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[4]), keyboxes[4], FALSE, FALSE, 0);


  hboxes[5] = gtk_hbox_new (TRUE, 0);
  keyboxes[5] = gtk_entry_new ();

  GetKeyText (buf, keyprefs.quit.modifiers, keyprefs.quit.key);
  gtk_entry_set_text (GTK_ENTRY(keyboxes[5]), buf);

  gtk_box_pack_start (GTK_BOX(vbox2), hboxes[5], FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[5]), gtk_label_new ("Quit"), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[5]), keyboxes[5], FALSE, FALSE, 0);


  hboxes[6] = gtk_hbox_new (TRUE, 0);
  keyboxes[6] = gtk_entry_new ();

  GetKeyText (buf, keyprefs.rename.modifiers, keyprefs.rename.key);
  gtk_entry_set_text (GTK_ENTRY(keyboxes[6]), buf);

  gtk_box_pack_start (GTK_BOX(vbox2), hboxes[6], FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[6]), gtk_label_new ("Rename Term"), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[6]), keyboxes[6], FALSE, FALSE, 0);


  hboxes[7] = gtk_hbox_new (TRUE, 0);
  keyboxes[7] = gtk_entry_new ();

  GetKeyText (buf, keyprefs.run.modifiers, keyprefs.run.key);
  gtk_entry_set_text (GTK_ENTRY(keyboxes[7]), buf);
  
  gtk_box_pack_start (GTK_BOX(vbox2), hboxes[7], FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[7]), gtk_label_new ("Run..."), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(hboxes[7]), keyboxes[7], FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX(vbox1), gtk_hseparator_new(), FALSE, FALSE, 0);  
  gtk_box_pack_start (GTK_BOX(vbox2), gtk_hseparator_new(), FALSE, FALSE, 0);


  for (a=0;a<10;a++)
    {
      hboxes[8+a] = gtk_hbox_new (TRUE, 0);
      keyboxes[8+a] = gtk_entry_new ();
      
      GetKeyText (buf, keyprefs.specific_term[a].modifiers, keyprefs.specific_term[a].key);
      gtk_entry_set_text (GTK_ENTRY(keyboxes[8+a]), buf);
      
      gtk_box_pack_start (GTK_BOX(vbox1), hboxes[8+a], FALSE, FALSE, 0);
      sprintf (buf, "Switch to term %d", a+1);
      gtk_box_pack_start (GTK_BOX(hboxes[8+a]), gtk_label_new (buf), FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX(hboxes[8+a]), keyboxes[8+a], FALSE, FALSE, 0);

      hboxes[18+a] = gtk_hbox_new (TRUE, 0);
      keyboxes[18+a] = gtk_entry_new ();
      
      GetKeyText (buf, keyprefs.specific_term[a+10].modifiers, keyprefs.specific_term[a+10].key);
      gtk_entry_set_text (GTK_ENTRY(keyboxes[18+a]), buf);
      
      gtk_box_pack_start (GTK_BOX(vbox2), hboxes[18+a], FALSE, FALSE, 0);
      sprintf (buf, "Switch to term %d", a+11);
      gtk_box_pack_start (GTK_BOX(hboxes[18+a]), gtk_label_new (buf), FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX(hboxes[18+a]), keyboxes[18+a], FALSE, FALSE, 0);

    }

  for (a=0;a<28;a++)
    {
      gtk_signal_connect (GTK_OBJECT (keyboxes[a]),
			  "key-press-event",
			  GTK_SIGNAL_FUNC (shortcut_key_event),
			  a);
    }

  keys[0] = keyprefs.cycle_forwards.key;
  modifiers[0] = keyprefs.cycle_forwards.modifiers;

  keys[1] = keyprefs.cycle_backwards.key;
  modifiers[1] = keyprefs.cycle_backwards.modifiers;

  keys[2] = keyprefs.move_forwards.key;
  modifiers[2] = keyprefs.move_forwards.modifiers;

  keys[3] = keyprefs.move_backwards.key;
  modifiers[3] = keyprefs.move_backwards.modifiers;
  
  keys[4] = keyprefs.close.key;
  modifiers[4] = keyprefs.close.modifiers;

  keys[5] = keyprefs.quit.key;
  modifiers[5] = keyprefs.quit.modifiers;

  keys[6] = keyprefs.rename.key;
  modifiers[6] = keyprefs.rename.modifiers;

  keys[7] = keyprefs.run.key;
  modifiers[7] = keyprefs.run.modifiers;

  for (a=0;a<20;a++)
    {
      keys[8+a] = keyprefs.specific_term[a].key;
      modifiers[8+a] = keyprefs.specific_term[a].modifiers;
    }

  


}

int ApplyPrefsShortcuts ()
{
  int a;

  keyprefs.cycle_forwards.key = keys[0];
  keyprefs.cycle_forwards.modifiers = modifiers[0];

  keyprefs.cycle_backwards.key = keys[1];
  keyprefs.cycle_backwards.modifiers = modifiers[1];

  keyprefs.move_forwards.key = keys[2];
  keyprefs.move_forwards.modifiers = modifiers[2];

  keyprefs.move_backwards.key = keys[3];
  keyprefs.move_backwards.modifiers = modifiers[3];

  keyprefs.close.key = keys[4];
  keyprefs.close.modifiers = modifiers[4];

  keyprefs.quit.key = keys[5];
  keyprefs.quit.modifiers = modifiers[5];

  keyprefs.rename.key = keys[6];
  keyprefs.rename.modifiers = modifiers[6];

  keyprefs.run.key = keys[7];
  keyprefs.run.modifiers = modifiers[7];

  for (a=0;a<20;a++)
    {
      keyprefs.specific_term[a].key = keys[8+a];
      keyprefs.specific_term[a].modifiers = modifiers[8+a];
    }


}
