/*
 *  $Id: info.c,v 1.9 2001/10/02 00:57:09 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <assert.h>
#include <linux/hdreg.h>

#include <powertweak.h>
#include <config.h>

#include "hdparm.h"


static char *make_buffers(struct hd_driveid *hd)
{
	char *bufptr;
	char *buffer;
	char onesec[]="1 Sector";
	char dualport[]="Dual Port";
	char dualportcache[]="Dual Port Cache";
	int sz;

	if(hd->buf_size==0) {
		buffer = strdup ("None");
		return buffer;
	}

	buffer = malloc (32);
	if (buffer==NULL)
		return NULL;

	bufptr = buffer;
	sz = snprintf (buffer, 32, "%dKb ", hd->buf_size / 2);
	bufptr += sz;
	sz = 32 - sz;

	switch(hd->buf_type) {
		case 1:
			snprintf (bufptr, sz, "%s", onesec);
			break;
		case 2:
			snprintf (bufptr, sz, "%s", dualport);
			break;
		case 3:
			snprintf (bufptr, sz, "%s", dualportcache);
			break;
		default:
			snprintf (bufptr, sz, "Unknown type [%d]", hd->buf_type);
			break;
	}
	return buffer;
}


static char *make_geometry(struct hd_driveid *hd)
{
	char *buf;
	buf = malloc (32);
	if (buf != NULL)
		snprintf(buf, 32, "%d/%d/%d", hd->cyls, hd->heads, hd->sectors);
	return buf;
}


void Add_Info_Page (char *MenuName, char *DeviceName, int fd)
{
	struct hd_driveid hd;
	struct private_hdparm_data *private;
	struct tweak *tweak;
	char *Menu1 = "Hardware";
	char *Menu2 = "Disk";
	char *Tabname = "Information";
	char *bufptr, *geom;
	int id;

	memset (&hd, 0, sizeof(hd));
	id = ioctl (fd, HDIO_GET_IDENTITY, &hd);
	tweak = alloc_hdparm_tweak (DeviceName, TYPE_INFO_STRING);
	tweak->WidgetText = strdup ("Model");
	private = (struct private_hdparm_data *) tweak->PrivateData;
	private->Type = HD_GETID;
	if (id == -1) {	/* Olde drive, can't ID it. */
		private->value.strVal = strdup ("Legacy MFM/RLL drive");
		RegisterTweak (tweak, "mmmt", Menu1, Menu2, MenuName, Tabname);
		return;
	}
	private->value.strVal = strdup (hd.model);
	RegisterTweak (tweak, "mmmth", Menu1, Menu2, MenuName, Tabname, "ID.");

	tweak = alloc_hdparm_tweak (DeviceName, TYPE_INFO_STRING);
	tweak->WidgetText = strdup("Firmware");
	private = (struct private_hdparm_data *) tweak->PrivateData;
	private->value.strVal = malloc(9);
	strncpy (private->value.strVal, hd.fw_rev, 8);
	memset (private->value.strVal+8, 0, 1);
	private->Type = HD_GETFIRMWARE;
	RegisterTweak (tweak, "mmmth", Menu1, Menu2, MenuName, Tabname, "ID.");

	tweak = alloc_hdparm_tweak(DeviceName, TYPE_INFO_STRING);
	tweak->WidgetText = strdup("Serial No.");
	private = (struct private_hdparm_data *) tweak->PrivateData;
	private->value.strVal = strdup (hd.serial_no);
	private->Type = HD_GETSERIAL;
	RegisterTweak (tweak, "mmmth", Menu1, Menu2, MenuName, Tabname, "ID.");

	geom = make_geometry (&hd);
	if ((hd.cyls + hd.heads + hd.sectors != 0) && (geom!=NULL)) {
		tweak = alloc_hdparm_tweak(DeviceName, TYPE_INFO_STRING);
		tweak->WidgetText = strdup("Geometry");
		private = (struct private_hdparm_data *) tweak->PrivateData;
		private->value.strVal = geom;
		private->Type = HD_GETGEOMETRY;
		RegisterTweak (tweak, "mmmth", Menu1, Menu2, MenuName, Tabname, "Drive Geometry.");
	}

	bufptr = make_buffers (&hd);
	if (bufptr!=NULL) {
		tweak = alloc_hdparm_tweak(DeviceName, TYPE_INFO_STRING);
		tweak->WidgetText = strdup("Cache");
		private = (struct private_hdparm_data *) tweak->PrivateData;
		private->value.strVal = bufptr;
		private->Type = HD_GETCACHE;
		RegisterTweak (tweak, "mmmth", Menu1, Menu2, MenuName, Tabname, "Cache information.");
	}
}
