/* $Id: getopts.c,v 1.1.1.1 2001/04/23 14:26:40 ossi Exp $ *
 *
 * puf 0.9  Copyright (C) 2000,2001 by Oswald Buddenhagen <puf@ossi.cjb.net>
 * based on puf 0.1.x (C) 1999,2000 by Anders Gavare <gavare@hotmail.com>
 *
 * You may modify and distribute this code under the terms of the GPL.
 * The is NO WARRANTY of any kind. See COPYING for details.
 *
 * getopts.c - command line parsing
 *
 */

#include "puf.h"


/*  Did user specify URL?  */
int tried_url = 0;

char *url_prefix = NULL;
char *disposition = NULL;
int enumerate_urls = 0;
int cur_url = 0;
int recurse_type = NOT_RECURSIVE;

void adden(char *url, int recurse)
{
    char buf[SHORTSTR], dbuf[20], *ptr, *proxy;
    int strict;

    strict = 0;
    if ((ptr = strchr(url, '^'))) {
	*ptr = '\0';
	proxy = ptr + 1;
	if (*proxy == '^') {
	    proxy++;
	    strict = 1;
	}
    } else
	proxy = 0;

    if ((ptr = strchr(url, '*'))) {
	*ptr = '\0';
	disposition = ptr + 1;
    } else if (enumerate_urls) {
	sprintf(dbuf, "%d.puf", ++cur_url);
	disposition = dbuf;
    }

    snprintf(buf, SHORTSTR, "%s%s", url_prefix ? url_prefix : "", url);
    dbg(URL, ("Trying URL '%s' from command line\n", buf));
    if (!parse_add_url(buf, strlen(buf), disposition, 
		       proxy ? parse_proxy(proxy, 1) : 0, strict,
		       0, 2, 0, recurse))
	prx(ERR, "Invalid URL '%s'.\n", buf);
    tried_url++;
    disposition = NULL;
}

void prx_adden(char *proxy)
{
    char *ptr;
    int ratio;

    if ((ptr = strchr(proxy, '*'))) {
	*ptr = '\0';
	ratio = atoi(ptr + 1);
	if (ratio <= 0)
	    die(1, "invalid load ratio '%s'.", ptr + 1);
    } else
	ratio = 100;

    if (!parse_proxy(proxy, ratio))
	prx(ERR, "Invalid proxy specification '%s'.", proxy);
    else
	use_proxy++;
}

void add_bind_ip(char *ip)
{
    static int bind_addr_anum;
    int s;

    if ((bind_addr.sin_addr.s_addr = inet_addr(ip)) == (unsigned)-1)
	die(2, "'%s' is not a valid IP address.", ip);
    if ((s = socket(PF_INET, SOCK_STREAM, 0)) < 0 )
	die(2, "cannot open test socket.");
    if (bind(s, (struct sockaddr *)&bind_addr, sizeof(struct sockaddr)))
	die(2, "cannot bind to %s.", ip);
    close(s);
    if (bind_addr_num == bind_addr_anum) {
	bind_addr_anum = bind_addr_anum * 2 + 1;
	if (!(bind_addr_ptr = realloc(bind_addr_ptr, bind_addr_anum * 
				      sizeof(bind_addr.sin_addr))))
	    die(2, "out of memory.");
    }
    bind_addr_ptr[bind_addr_num++] = bind_addr.sin_addr;
}

void adden_agent(char *agent, int perc)
{
    int len = strlen(agent) + 1;
    agent_t *ag;

    if (!(ag = malloc(sizeof(agent_t) + len)))
	die(2, "out of memory.");
    lnq_append(user_agents, ag);
    ag->ratio = perc;
    uar_total += perc;
    memcpy(ag->agent, agent, len);
}

void add_agent(char *agent)
{
    int perc = -1, nch;

    sscanf(agent, "%i %n", &perc, &nch);
    if (perc < 0)
	die(2, "invalid percentage/agent spec '%s'.", agent);
    adden_agent(agent + nch, perc);
}

enum { O_ST_I, O_ST_O, O_ST_CI, O_ST_S, O_RF_S, O_HELP, O_URLF, 
       O_PRX, O_PRXF, O_HDR, O_BIND, O_BINDF, O_AGENT, O_AGENTF };

char *onams[] = { "NR", "NR", "", "STR", "STR", "", "FILE", 
		  "PRX", "FILE", "STR", "IP", "FILE", "STR", "FILE" };

/* *INDENT-OFF* */
struct {                      
    char *opt;
    int todo;
    void *argptr;
    int argval;
    char *desc;
    int descarg;
} options[] = {
    {0, -1, 0, 0, "\nSPEC format: URL[*disposition][^[^]proxy-URL]\n"
		    "URL format: [http://][user:pass@]host[.domain][:port][/path]\n""
		    \nWhat to download:", 0},
    {"ri", O_ST_CI, &recurse_type, IMAGE_RECURSIVE, "Also download referenced images and frames", 0},
    {"r", O_ST_CI, &recurse_type, SUBDIR_RECURSIVE, "Recurse download into subdirectories", 0},
    {"r+", O_ST_CI, &recurse_type, HOST_RECURSIVE, "Recurse download across whole server", 0},
    {"r++", O_ST_CI, &recurse_type, GLOBAL_RECURSIVE, "Recurse download across whole net (caution!)", 0},
    {0, -1, 0, 0, "     note: the -r... options affect only the next SPEC or -i switch!", 0},
    {"ld", O_ST_I, &max_depth, 0, "Limit directory recursion depth to NR (with -r)", 0},
    {"lb", O_ST_O, &max_url_bytes, 0, "Download only first NR bytes of every SPEC", 0},
    {"xg", O_ST_CI, &inhibit_cgiget, -1, "Allow recursion into URLs with ? signs (i.e., CGIs)", 0},
    {"ng", O_ST_CI, &inhibit_cgiget, 1, "Disallow ?-URLs, even if given on the command line", 0},
    {"F", O_ST_CI, &force_recurse, 1, "Treat all files as HTML (scan for links)", 0},
    {"p", O_RF_S, &url_prefix, 0, "Prefix to add to every SPEC on the command line", 0},
    {"i", O_URLF, 0, 0, "Read SPECs from FILE", 0},
    {0, -1, 0, 0, "\nWhat to to with existing files:", 0},
    {"u", O_ST_CI, &update_mode, EX_UPDATE, "Update existing "/* "and delete obsolete "*/"files, continue partial", 0},
    {"c", O_ST_CI, &update_mode, EX_CONTINUE, "Continue download of partial files", 0},
    {"nc", O_ST_CI, &update_mode, EX_NO_CLOBBER, "Don't clobber existing files", 0},
    {0, -1, 0, 0, "\nStorage of files:", 0},
    {"na", O_ST_CI, &always_primary_name, 1, "Don't use hostname aliases for directory names", 0},
    {"nd", O_ST_CI, &dir_mode, DIRS_NONE, "Don't create subdirectories", 0},
    {"xd", O_ST_CI, &dir_mode, DIRS_ALWAYS, "Create all subdirectories (default for -r+ & -r++)", 0},
    {"O", O_RF_S, &disposition, 0, "Save next SPEC to file STR", 0},
    {"P", O_RF_S, &disposition_path, 0, "Save files to directory STR/", 0},
    {"xi", O_RF_S, &index_filename, 0, "Set the name for anonymous index files (default is " DEFAULT_INDEX_FILE_NAME ")", 0},
    {"xe", O_ST_CI, &enumerate_files, 1, "Enumerate files (1.puf, ...). Implies -nd", 0},
    {"xE", O_ST_CI, &enumerate_urls, 1, "Enumerate files in command line order. Implies -nd", 0},
    {"nt", O_ST_CI, &no_touch, 1, "Don't timestamp files according to server response", 0},
    {"nb", O_ST_CI, &delete_broken, 1, "Delete partial files from broken downloads", 0},
/*  {"xr", O_ST_CI, &regard_disposition, 1, "Regard \"Disposition:\" HTTP headers", 0}, */
    {0, -1, 0, 0, "\nNetwork options:", 0},
    {"ni", O_ST_CI, &send_if_range, 0, "Don't send \"If-Range:\" (assume up-to-date partial files)", 0},
    {"nR", O_ST_CI, &send_referer, 0, "Don't send \"Referer:\"", 0},
    {"U", O_AGENT, 0, 0, "Send \"User-Agent: STR\" (use \"\" for none)", 0},
    {"iU", O_AGENTF, 0, 0, "Choose User-Agent strings from FILE", 0},
    {"xH", O_HDR, 0, 0, "Add arbitarary header STR to HTTP requests", 0},
    {"Tl", O_ST_I, &timeout_dns, 0, "Set DNS lookup timeout to NR seconds (default is %i)", DEFAULT_TIMEOUT_DNS},
    {"Tc", O_ST_I, &timeout_connect, 0, "Set connect timeout to NR seconds (default is %i)", DEFAULT_TIMEOUT_CONNECT},
    {"Td", O_ST_I, &timeout_data, 0, "Set data timeout to NR seconds (default is %i)", DEFAULT_TIMEOUT_DATA},
    {"t", O_ST_I, &max_attempts, 0, "Set maximum number of download attempts per URL (default is %i)", DEFAULT_MAX_ATTEMPTS},
    {"nw", O_ST_CI, &fail_no_wait, 1, "Don't wait before connecting a busy/dead host", 0},
    {"xb", O_BIND, 0, 0, "Bind outgoing connections to IP", 0},
    {"ib", O_BINDF, 0, 0, "Bind outgoing connections to random IPs from FILE", 0},
    {"y", O_PRX, 0, 0, "Use proxy PRX. Multiple -y's are allowed", 0},
    {"yi", O_PRXF, 0, 0, "Read proxies from FILE. PRX format: URL[*load ratio]", 0},
    {0, -1, 0, 0, "\nResource usage quotas:", 0},
    {"Q", O_ST_O, &max_bytes, 0, "Abort puf after NR bytes (unlimited by default)", 0},
    {"Qu", O_ST_I, &max_urls, 0, "Abort puf after NR URLs (unlimited by default)", 0},
    {"Qt", O_ST_I, &max_time, 0, "Abort puf after NR seconds (unlimited by default)", 0},
    {"lc", O_ST_I, &max_urls_active, 0, "Max NR simultaneous connections (default is %i)", DEFAULT_MAX_ACTIVE},
    {"ll", O_ST_I, &max_dns_forks, 0, "Max NR simultaneous DNS lookups (default is %i)", DEFAULT_MAX_DNS_FORKS},
    {"nf", O_ST_CI, &economize_files, 1, "Use fewer file descriptors. Slightly slower", 0},
    {"nh", O_ST_CI, &economize_dns, 1, "Do fewer DNS lookups. May miss some references", 0},
    {0, -1, 0, 0, "\nLogging:", 0},
    {"ns", O_ST_CI, &show_stat, 0, "Disable download progress statistics", 0},
    {"v", O_ST_CI, &verbose, ERR, "Be verbose (show errors). Implies -ns", 0},
    {"vv", O_ST_CI, &verbose, WRN, "Be very verbose (show warnings). Implies -v", 0},
    {"vvv", O_ST_CI, &verbose, NFO, "Be extremely verbose (show infos). Implies -vv", 0},
    {"d", O_ST_I, &debug, 0, "Debug: URL=1 DNS=2 QUE=4 CON=8 HDR=16 CHK=32 MEM=64", 0},
    {"h", O_HELP, 0, 0, "This help screen", 0},
};
/* *INDENT-ON* */

void showhelp_advanced()
{
    char ona[SHORTSTR];
    unsigned i;

    for (i = 0; i < sizeof(options) / sizeof(options[0]); i++) {
	if (options[i].opt) {
	    sprintf(ona, "%s %s", options[i].opt, onams[options[i].todo]);
	    printf("  -%-9s", ona);
	}
	printf(options[i].desc, options[i].descarg);
	printf("\n");
    }
}

void showhelp_basic()
{
    printf("Usage: %s [options] [SPEC...]\n", progname);
}

void showhelp()
{
    showhelp_basic();
    printf("\nTry '%s -h' for more information.\n", progname);
}

char *mfgets(char *buf, int len, FILE *f)
{
    int ba, be, bp;

    for (;;) {
      nxtl:
	if (fgets(buf, len, f)) {
	    for (ba = 0; buf[ba] <= ' '; ba++)
		if (!buf[ba])
		    goto nxtl;
	    if (buf[ba] == '#')
		continue;
	    for (be = (bp = ba) - 1; buf[bp]; bp++)
		if (buf[bp] > ' ')
		    be = bp;
	    buf[be + 1] = 0;
	    return buf + ba;
	}
	return 0;
    }
}

void getopts(int argc, char *argv[])
{
    char buf[SHORTSTR], *fbad;
    int oind, oint, dopts = 0;
    unsigned i;
    off_t oll;
    FILE *f;

    for (oind = 1; oind < argc; oind++) {
	if (!dopts && argv[oind][0] == '-') {
	    for (i = 0; i < sizeof(options) / sizeof(options[0]); i++)
		if (options[i].opt && !strcmp(argv[oind] + 1, options[i].opt))
		    goto fopt;
	    die(2, "Unrecognized option '%s'.", argv[oind]);
	  fopt:
	    if (options[i].todo == O_ST_CI)
		*(int *)options[i].argptr = options[i].argval;
	    else if (options[i].todo == O_HELP) {
		showhelp_basic();
		showhelp_advanced();
		exit(0);
	    } else {
		if (++oind >= argc)
		    die(2, "Missing argument to option '%s'.",
			argv[oind - 1]);
		switch (options[i].todo) {
		    case O_ST_I:
			oint = strtol(argv[oind], &fbad, 0);
			if (*fbad || oint < 1)
			    die(2,
				"Invalid numeric argument '%s' to option '%s'.",
				argv[oind], argv[oind - 1]);
			*(int *)options[i].argptr = oint;
			break;
		    case O_ST_O:
			fbad = argv[oind];
			oll = 0;
			if (*fbad == '0' && fbad[1] == 'x') {
			    fbad += 2;
			    while (isxdigit((int)*fbad)) {
				oll =
				    oll * 16 + (isdigit((int)*fbad) ? *fbad -
						'0' : tolower((int)*fbad) -
						'a' + 10);
				fbad++;
			    }
			} else
			    while (isdigit((int)*fbad)) {
				oll = oll * 10 + (*fbad - '0');
				fbad++;
			    }
			if (*fbad == 'k') {
			    oll *= 1024; fbad++;
			} else if (*fbad == 'm') {
			    oll *= 1024 * 1024; fbad++;
			} else if (*fbad == 'g') {
			    oll *= 1024 * 1024 * 1024; fbad++;
			}
			if (*fbad)
			    die(2,
				"Invalid numeric argument '%s' to option '%s'.",
				argv[oind], argv[oind - 1]);
			*(off_t *)options[i].argptr = oll;
			break;
		    case O_RF_S:
			*(char **)options[i].argptr = argv[oind];
			break;
		    case O_ST_S:
			oint = strlen(argv[oind]);
			if (oint >= SHORTSTR)
			    die(2,
				"Argument '%.10s...' to parameter '%s' is too long.",
				argv[oind], argv[oind - 1]);
			memcpy(options[i].argptr, argv[oind], oint + 1);
			break;
		    case O_BIND:
			add_bind_ip(argv[oind]);
			break;
		    case O_BINDF:
			if (!(f = fopen(argv[oind], "r")))
			    die(2, "Cannot open IP list '%s'.", argv[oind]);
		    	while ((fbad = mfgets(buf, sizeof(buf), f)) != 0)
			    add_bind_ip(fbad);
			fclose(f);
			break;
		    case O_AGENT:
			adden_agent(argv[oind], 1);
			break;
		    case O_AGENTF:
			if (!(f = fopen(argv[oind], "r")))
			    die(2, "Cannot open User-Agent list '%s'.", argv[oind]);
		    	while ((fbad = mfgets(buf, sizeof(buf), f)) != 0)
			    add_agent(fbad);
			fclose(f);
			break;
		    case O_URLF:
			if (!strcmp(argv[oind], "-"))
			    f = stdin;
			else if (!(f = fopen(argv[oind], "r")))
			    die(2, "Cannot open URL list '%s'.", argv[oind]);
		    	while ((fbad = mfgets(buf, sizeof(buf), f)) != 0)
			    adden(fbad, recurse_type);
			if (f != stdin)
			    fclose(f);
			recurse_type = NOT_RECURSIVE;
			break;
		    case O_PRX:
			prx_adden(argv[oind]);
			break;
		    case O_PRXF:
			if (!(f = fopen(argv[oind], "r")))
			    die(2, "Cannot open proxy list '%s'.", argv[oind]);
		    	while ((fbad = mfgets(buf, sizeof(buf), f)) != 0)
			    prx_adden(fbad);
			fclose(f);
			break;
		    case O_HDR:
			if (naddhdrs >= MAX_ADD_HEADERS)
			    die(2, "At most %d additional headers can be "
				"added.", MAX_ADD_HEADERS);
			addhdrs[naddhdrs++] = argv[oind];
			break;
		}
	    }
	} else if (!dopts && !strcmp(argv[oind], "--")) {
	    dopts++;
	} else {
	    adden(argv[oind], recurse_type);
	    recurse_type = NOT_RECURSIVE;
	}
    }

    /*  If no url was given, show help message:  */
    if (!tried_url) {
	showhelp();
	exit(2);
    }

    if ((verbose
#ifdef DEBUG
	 || debug
#endif
	) && isatty(2))
	show_stat = 0;

    if (!user_agents) {
	struct utsname un;
	char http_agent[SHORTSTR];

	uname(&un);
	snprintf(http_agent, SHORTSTR, PACKAGE "/" VERSION " (%s %s; %s)",
		 un.sysname, un.release, un.machine);
	adden_agent(http_agent, 1);
    }

}
