# IANA assignments
#http://www.iana.org/assignments/http-status-codes/http-status-codes.xml

s = dict()
s[100] = "Continue"
s[101] = "Switching Protocols"
s[102] = "Processing"
s[200] = "OK"
s[201] = "Created"
s[202] = "Accepted"
s[203] = "Non-Authoritative Information"
s[204] = "No Content"
s[205] = "Reset Content"
s[206] = "Partial Content"
s[207] = "Multi-Status"
s[208] = "Already Reported"
s[226] = "IM Used"
s[300] = "Multiple Choices"
s[301] = "Moved Permanently"
s[302] = "Found"
s[303] = "See Other"
s[304] = "Not Modified"
s[305] = "Use Proxy"
s[306] = "Reserved"
s[307] = "Temporary Redirect"
s[308] = "Permanent Redirect"
s[400] = "Bad Request"
s[401] = "Unauthorized"
s[402] = "Payment Required"
s[403] = "Forbidden"
s[404] = "Not Found"
s[405] = "Method Not Allowed"
s[406] = "Not Acceptable"
s[407] = "Proxy Authentication Required"
s[408] = "Request Timeout"
s[409] = "Conflict"
s[410] = "Gone"
s[411] = "Length Required"
s[412] = "Precondition Failed"
s[413] = "Request Entity Too Large"
s[414] = "Request-URI Too Long"
s[415] = "Unsupported Media Type"
s[416] = "Requested Range Not Satisfiable"
s[417] = "Expectation Failed"
s[422] = "Unprocessable Entity"
s[423] = "Locked"
s[424] = "Failed Dependency"
s[426] = "Upgrade Required"
s[428] = "Precondition Required"
s[429] = "Too Many Requests"
s[431] = "Request Header Fields Too Large"
s[500] = "Internal Server Error"
s[501] = "Not Implemented"
s[502] = "Bad Gateway"
s[503] = "Service Unavailable"
s[504] = "Gateway Timeout"
s[505] = "HTTP Version Not Supported"
s[506] = "Variant Also Negotiates"
s[507] = "Insufficient Storage"
s[508] = "Loop Detected"
s[510] = "Not Extended"
s[511] = "Network Authentication Required"

def get_reason(code):
	if code in s:
		return s[code]
	else:
		return "Undefined Reason"
