#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2014 Martin Raspaud

# Author(s):

#   Martin Raspaud <martin.raspaud@smhi.se>

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Converts text to python
"""


txt = {"noaa14":
       """95013 	223633 	-0.37 	95213 	233350 	0.59
95214 	011409 	-0.93 	95365 	225835 	0.04
95365 	211723 	0.53 	96079 	234708 	1.07
96080 	012736 	-0.43 	96222 	230133 	0.59
96223 	004223 	0.07 	96289 	223559 	0.58
96290 	001652 	-0.93 	97126 	223140 	0.69
97127 	001236 	0.18 	97182 	001344 	0.64
97182 	015422 	1.63 	97196 	230953 	1.75
97197 	005044 	0.25 	97231 	232830 	0.55
97232 	010911 	0.03 	97302 	000502 	0.63
97302 	014537 	-0.90 	98111 	234827 	0.55
98112 	012906 	0.04 	98181 	223817 	0.62
98181 	001812 	-0.88 	98342 	230000 	0.45
98343 	000000 	-0.05 	98365 	202823 	0.14
98365 	220000 	-0.34 	99131 	205700 	0.72
99132 	002800 	0.22 	99222 	235900 	0.97
99223 	010000 	-0.52 	99310 	235900 	0.15
99311 	000000 	-0.65 	00018 	235900 	-0.02
00019 	000000 	-0.50 	00238 	235900 	0.70""",

       "noaa11":
       """88270 	175315 	0.10 	88362 	225730 	0.55
88363 	003825 	-0.45 	89108 	223157 	0.55
89109 	001247 	-1.21 	89283 	223149 	0.92
89284 	001246 	-0.99 	90001 	005132 	0.19
90001 	062225 	-0.81 	90086 	225343 	0.51
90087 	003437 	-0.48 	90157 	232813 	0.67
90158 	010906 	-0.33 	90200 	185021 	0.40
90206 	004808 	0.68 	90210 	000412 	0.76
90214 	063112 	0.10 	90233 	230231 	0.53
90234 	004321 	-0.47 	90296 	231326 	0.66
90297 	005426 	-0.35 	90345 	223316 	0.54
90346 	072437 	-0.44 	91037 	234244 	0.63
91038 	012353 	-0.38 	91078 	224447 	0.42
91079 	002546 	-0.59 	91127 	233159 	0.36
91128 	011307 	-0.64 	91176 	204252 	0.35
91177 	001500 	-0.67 	91232 	233429 	0.47
91233 	011521 	-0.54 	91281 	223014 	0.44
91282 	001116 	-0.57 	91330 	230237 	0.45
91331 	004335 	-0.56 	92014 	233119 	0.47
92015 	011217 	-0.53 	92056 	233822 	0.36
92057 	011908 	-0.64 	92105 	235823 	0.46
92106 	013910 	-0.55 	92147 	235749 	0.38
92148 	013925 	-0.63 	92210 	230706 	0.74
92211 	004718 	-0.26 	92252 	230538 	0.70
92253 	004621 	-0.32 	92308 	215437 	0.96
92309 	082622 	-0.05 	92336 	225954 	0.59
92337 	003847 	-0.42 	93012 	225434 	0.56
93013 	003543 	-0.46 	93047 	223341 	0.36
93048 	001415 	-0.67 	93089 	222657 	0.33
93090 	014845 	-0.68 	93138 	223524 	0.47
93139 	001555 	-0.55 	93181 	235524 	0.51
93182 	013608 	-0.50 	93234 	231252 	0.78
93235 	005344 	-0.21 	93271 	221249 	0.68
93272 	000413 	-0.33 	93313 	235403 	0.70
93314 	013043 	-0.33 	93355 	234331 	0.73
93356 	012432 	-0.28 	94032 	233238 	0.77
94033 	011326 	-0.24 	94067 	230533 	0.64
94068 	004655 	-0.38 	94109 	224303 	0.69
94110 	003436 	-0.34 	94144 	221719 	0.57
94145 	000747 	-0.43 	94181 	230407 	0.50
94182 	005611 	-1.51 	94209 	173715 	-0.81
94209 	204026 	0.23 	94221 	232635 	0.54
94222 	010716 	-0.45 	94256 	224431 	0.45
94257 	003856 	-0.59 	94298 	223205 	0.53
94299 	002843 	-0.47 	94340 	221659 	0.65
94341 	001032 	-0.38 	95012 	164514 	0.60
95013 	194752 	-0.36 	95052 	231636 	0.67
95053 	010842 	-0.33 	95094 	225950 	0.77
95095 	005202 	-0.23 	95208 	163447 	2.81
95208 	163450 	2.81 	96004 	165442 	7.36""",

       "noaa7":
       """81179 	000000 	0.1 	82003 	235959 	0.8
82004 	000000 	0.8 	82053 	235959 	1.1
82054 	000000 	-0.5 	82181 	235959 	0.1
82182 	000000 	-0.6 	83025 	235959 	0.3
83026 	000000 	-0.1 	83181 	235959 	0.5
83182 	000000 	1.5 	83193 	235959 	1.6
83194 	000000 	-0.7 	84081 	235959 	0.3
84082 	000000 	-1.1 	84342 	235959 	-0.1
84343 	000000 	-0.9 	84366 	235959 	-0.8
85001 	000000 	0.0 	85107 	235959 	0.4
85108 	000000 	0.2 	85136 	235959 	0.3
85137 	000000 	-1.1 	85181 	235959 	-1.0
85182 	000000 	-0.0 	85304 	235959 	0.4
85305 	000000 	-0.3 	86148 	235959 	0.3
86149 	000000 	-1.3 	86158 	235959 	-1.3""",

       "noaa9":
       """86014 	183754 	-0.53 	86051 	090207 	-0.80
86051 	184443 	0.45 	86190 	092344 	-0.76
86190 	190707 	0.46 	86308 	195123 	-0.80
86309 	081339 	0.47 	87048 	210941 	-0.84
87049 	075241 	0.40 	87139 	195622 	-0.85
87140 	081825 	0.39 	87216 	210921 	-0.75
87217 	075309 	0.48 	87293 	204300 	-0.77
87294 	090756 	0.48 	87365 	225918 	-0.79
88001 	004020 	0.21 	88061 	234258 	-0.89
88062 	012352 	0.36 	88125 	000338 	-0.87
88125 	014432 	0.39 	88187 	224121 	-0.87
88188 	002232 	0.40 	88250 	225846 	-0.93
88251 	022040 	0.32 	88306 	224954 	-0.89
88307 	003033 	0.35 	88363 	001536 	-0.88
88363 	015925 	0.37 	89023 	110528 	-0.25
89024 	091318 	0.75 	89094 	111829 	-0.91
89095 	035705 	0.31 	89143 	031928 	-0.85
89144 	030810 	0.36 	89192 	111852 	-0.79
89193 	035610 	0.46 	89242 	232725 	-0.80
89243 	024905 	0.45 	89290 	035408 	-0.79
89291 	020143 	0.45 	89338 	101232 	-0.81
89339 	025034 	0.41 	89365 	212451 	-0.30
90001 	023815 	0.69 	90058 	102159 	-0.87
90059 	030319 	0.36 	90107 	105326 	-0.99
90108 	014914 	0.25 	90149 	221415 	-0.93
90150 	033528 	0.31 	90191 	222735 	-0.85
90192 	033935 	0.36 	90233 	110326 	-0.81
90234 	034148 	0.40 	90275 	110402 	-0.79
90276 	020138 	0.42 	90314 	095839 	-0.72
90320 	232628 	0.33 	90365 	224854 	-1.03
91001 	022659 	-0.07 	91022 	214259 	-0.71
91023 	030313 	0.52 	91064 	231826 	-0.76
91065 	025737 	0.47 	91106 	044021 	-0.82
91107 	024821 	0.39 	91142 	223525 	-0.72
91142 	224834 	0.16 	91176 	034520 	-0.88
91177 	033300 	0.31 	91211 	031322 	-0.78
91213 	043140 	0.39 	91231 	225648 	-0.21
91270 	042933 	-0.24 	91288 	224028 	-0.86
91289 	053517 	0.36 	91331 	000157 	-1.03
91331 	051428 	0.44 	92007 	233938 	-0.95
92008 	063157 	0.52 	92049 	231312 	-0.90
92050 	042700 	0.58 	92090 	195517 	-0.84
92091 	055256 	0.75 	92133 	221715 	-0.77
92134 	065146 	0.70 	92182 	234047 	-0.99
92183 	134449 	-0.01 	92207 	120034 	-0.87
92211 	124842 	0.45 	92236 	141404 	-0.42
92246 	233007 	0.71 	92287 	231141 	-0.78
92288 	060512 	0.68 	92329 	143633 	-0.79
92330 	002139 	0.69 	93005 	234707 	-0.87
93006 	064126 	0.63 	93047 	231538 	-0.91
93048 	060831 	0.57 	93089 	175433 	-0.96
93090 	002050 	0.52 	93136 	193915 	-1.26
93137 	020351 	0.25 	93166 	195650 	-0.88
93167 	004310 	0.62 	93182 	060334 	0.00
93182 	131313 	1.02 	93213 	181559 	-0.18
93243 	011321 	1.22 	93292 	194948 	-0.72
93293 	021545 	0.77 	93341 	210417 	-1.15
93343 	013534 	0.83 	94025 	203714 	-1.04
94026 	012315 	0.42 	94060 	194824 	-0.95
94061 	072640 	0.53 	94101 	020148 	-1.03
94103 	013547 	0.35 	94137 	200139 	-1.02
94138 	022803 	0.48 	94181 	235541 	-1.28
94182 	030236 	0.20 	94209 	193554 	-0.94
94210 	020305 	0.07 	94235 	204323 	-1.01
94236 	012744 	0.53 	94277 	214407 	-1.15
94278 	022908 	0.30 	94305 	204327 	-0.82
94306 	012723 	0.67 	94347 	150149 	-1.06
94348 	004630 	0.42 	95019 	202513 	-1.11
95020 	010905 	0.41 	95052 	195749 	-0.97
95053 	004426 	0.50 	95087 	190612 	-0.90
95088 	013146 	0.56 	95115 	212721 	-0.62
95116 	021019 	0.89 	95150 	203430 	-0.57
95151 	030113 	0.91 	95201 	193323 	-1.24
95202 	020016 	0.74 	95214 	200458 	0.21"""}


from datetime import datetime
import pprint

sat = None


def get_offsets(sat):
    """Get the clock drift offsets for sat.
    """
    errors = []
    offsets = txt[sat]
    for line in offsets.split("\n"):
        elts = line.split()

        errors.append((datetime.strptime("".join(elts[:2]), "%y%j%H%M%S"),
                       float(elts[2])))
        errors.append((datetime.strptime("".join(elts[3:5]), "%y%j%H%M%S"),
                       float(elts[5])))
    return zip(*errors)
