########################################################################
#
# File Name: 	       Enumeration.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Enumeration.py.html
#
"""
Implements the Enumeration meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import ScopedType

from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import Constant
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Enumeration(ScopedType.ScopedType):
    def __init__(self,db,data):
        ScopedType.ScopedType.__init__(self,db,data,MetaKind.mk_enumeration)


    #These three interfaces are for any scopedtype
    #We must support them
    def _4ods_getBoundChildren(self):
        return self.elements

    def _4ods_boundChild(self,obj):
        self.add_elements(obj)

    def _4ods_unboundChild(self,obj):
        self.remove_elements(obj)

    def add_elements(self,target,inverse=1):
        self._4ods_addRelationship('elements',Constant.Constant,'enumeration','form',target,inverse)
    form_elements = add_elements

    def remove_elements(self,target,inverse = 1):
        self._4ods_removeRelationship('elements','enumeration','drop',target,inverse)
    drop_elements = remove_elements

    def _4ods_getOdl(self,indent):
        st = indent+'enum %s {' % self.name
        for e in self.elements:
            st = st + '%s, ' % e.name
        st = st[:-2] + '}'
        return st

    def _4ods_checkRemove(self):
        return 1

    def _4ods_getOdmgType(self):
        return Constants.Types.ENUMERATION

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        found.append(self)

    def _4ods_findTypePath(self,object):
        return []


    _tupleNames =  (('elements',),)

    _tupleDefinitions = {'elements':{td.TYPE:Constants.Types.LIST_COLLECTION,
                                     td.READONLY:1,
                                     td.RELATIONSHIP:1,
                                     td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                     }
                         }

    _localExtents = ()
