#!/usr/bin/python
########################################################################
#
# File Name:            GenerateConstant.py
#
# Documentation:        http://docs.4suite.org/4ODS/GenerateConstant.py.html
#

#Desc.
#WWW: http://4suite.org/4ODS        e-mail: support@4suite.org

#Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
#See  http://4suite.org/COPYRIGHT  for license and copyright information

from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import PrimitiveKind
import os

import OdlUtil

from Ft.Ods.Exception import FtodsGenerationError

from Ft.Ods.MetaData import MetaKind, CollectionKind,PrimitiveKind

def GenerateStubs(c,params,fileName,useName,toSet):

    f = open(fileName,'a')

    #We need to determine what the output value should be, ie with quotes, etc
    typ = OdlUtil.NormalizeTypeDefinition(c.type)
    if typ.meta_kind == MetaKind.mk_primitive_type:
        if typ.primitive_kind == PrimitiveKind.pk_string:
            oString = '"' + c.value() + '"'
        elif typ.primitive_kind == PrimitiveKind.pk_boolean:
            if c.value():
                oString = '1'
            else:
                oString = '0'
        else:
            oString = str(c.value())
    elif typ.meta_kind == MetaKind.mk_collection \
         and typ.collection_kind == CollectionKind.ck_string:
        # Note: this case is probably not too useful!
        # might want to warn if the const string<n> was lopped off
        maxlen = typ.max_size.value()
        oString = '"' + c.value()[0:maxlen] + '"'
    else:
        raise FtodsGenerationError(message="Constant of Type %s not supported" % typ)

    f.write("%s=%s\n" % (useName,oString))

    if toSet:
        parentName, actualName = toSet
        f.write("%s.%s=%s\n" % (parentName,actualName,useName))
        f.write("del %s\n" % (useName))

    f.close()
    return



#Database creation interface
def SetMetaId(const,db):
    id = db.newMetaId('Constant')
    const.metaId = id

def InitDb(const,db):
    db.createConstant(const)
