#!/usr/bin/python
########################################################################
#
# File Name:            GenerateType
#
# Documentation:        http://docs.4suite.org/ODS/GenerateType.py.html
#

#Desc.
#WWW: http://4suite.org/4ODS        e-mail: support@4suite.org

#Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
#See  http://4suite.org/COPYRIGHT  for license and copyright information

#Contains the definitions for _all_ types in ODS, plus a base class
import string

from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import PrimitiveKind
from Ft.Ods.MetaData import CollectionKind
from Ft.Ods.Parsers.Odl import OdlUtil

from Ft.Ods.Exception import FtodsUnknownError

def WriteImports(typ,params):
    SplitByType(typ,params,('Write','Imports'))

def WriteCommit(typ,params):
    SplitByType(typ,params,('Write','Commit'))

def WriteInit(typ,params):
    SplitByType(typ,params,('Write','Init'))

def WriteRead(typ,params):
    SplitByType(typ,params,('Write','Read'))

def WriteWrite(typ,params):
    SplitByType(typ,params,('Write','Write'))

def WriteDelete(typ,params):
    SplitByType(typ,params,('Write','Delete'))

def WriteFtodsDelete(typ,params):
    SplitByType(typ,params,('Write','FtodsDelete'))

def SplitByType(typ,params,cmd):
    from Ft.Ods.Parsers.Odl import GenerateType
    typ = OdlUtil.NormalizeTypeDefinition(typ)
    if typ.meta_kind == MetaKind.mk_primitive_type:
        t = 'PrimitiveKind'
    elif typ.meta_kind == MetaKind.mk_collection:
        t = 'Collection'
    elif typ.meta_kind == MetaKind.mk_class:
        t = 'Interface'
    elif typ.meta_kind == MetaKind.mk_interface:
        t = 'Interface'
    elif typ.meta_kind == MetaKind.mk_enumeration:
        t = 'Enumeration'
    elif typ.meta_kind == MetaKind.mk_union:
        t = 'Union'
    else:
        raise FtodsUnknownError(msg="Unkown Type %s" % typ)
    cmd = cmd[0] + t + cmd[1]
    func = getattr(GenerateType,cmd)
    func(typ,params)




#Functions for each type
#####################
#The Primitives
####################

g_pyDefaultFromOdlType = {
    'float': "0.0",
    'double': "0.0",
    'unsigned short': "0",
    'unsigned long': "0L",
    'short': "0",
    'long': "0L",
    'char': "''",
    'boolean': "0",
    'octet': "0",
    'date': None,
    'time': None,
    'interval': None,
    'timestamp': None,
    'string': "''",
    'long long': "0L",
    'file':'""',
    }


def WritePrimitiveKindImports(typ,params):
    pass
def WritePrimitiveKindInit(typ,params):
    default_val = g_pyDefaultFromOdlType[typ._4ods_getOdl('')]
    if default_val is not None:
        params.outFile.write('%s'%(default_val))        




#####################
#Structures
#####################

def WriteStructureImports(typ,params):
    pass



#####################
#Interfaces
#####################

def WriteInterfaceImports(typ,params):
    params.outFile.write(params.indent)
    path = string.split(typ.absolute_name(),'::')
    if path[0] == 'ODLMetaObjects':
        path = path[1:]
    if params.basePackage:
        p = params.basePackage
        for curPath in path:
            if curPath == path[-1]:
                continue
            else:
                p = p + '.' + curPath
            
        params.outFile.write('from %s import %s\n' % (p,path[-1]))
    else:
        params.outFile.write('import %s\n' % (string.join(path,'.')))

def WriteInterfaceInit(typ,params):
    params.outFile.write("None")



def WriteCollectionImports(typ,params):
    pass



############################################
#Enumerations
############################################
def WriteEnumerationImports(typ,params):
    pass
    
############################################
#Unions
############################################
def WriteUnionImports(typ,params):
    pass
    
