########################################################################
#
# File Name:            Container.py
#
# Documentation:        http://docs.4suite.org/4Rdf/Container.py.html
#
"""
RDF Containers
WWW: http://4suite.org/4RDF         e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import UserList
from Ft.Rdf.Resource import Resource
from Ft.Rdf import RDF_MS_BASE


class Container(Resource, UserList.UserList):
    def __init__(self, className, uri=None, contents=None):
        #if uri == None:
        #    uri = model.generateUri()
        contents = contents or []
        Resource.__init__(self, uri)
        UserList.UserList.__init__(self, contents)
        self.className = className

    def __repr__(self):
        st = '<%s at %s URI="%s": ['%(self.className, id(self),self.uri)
        for i in self:
            st = st + repr(i) + ', '
        st = st[:-2] + ']>'
        return st


class Bag(Container):
    def __init__(self, uri=None, contents=None):
        Container.__init__(self, 'Bag', uri,contents)


class Sequence(Container):
    def __init__(self, uri=None, contents=None):
        Container.__init__(self, 'Seq', uri,contents)


class Alternative(Container):
    def __init__(self, uri=None, contents=None):
        Container.__init__(self, 'Alt', uri,contents)


baseLength = len(RDF_MS_BASE+'_')
def SortStatements(left,right):
    leftCtr = int(left.predicate[baseLength:])
    rightCtr = int(right.predicate[baseLength:])
    return cmp(leftCtr,rightCtr)
