########################################################################
#
# File Name:            __init__.py
#
# Documentation:        http://docs.4suite.org/4RDF/__init__.py.html
#
"""
WWW: http://4suite.org/4RDF         e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


RDF_MS_BASE = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#'
RDF_SCHEMA_BASE = "http://www.w3.org/2000/01/rdf-schema#"
RIL_NAMESPACE = 'http://namespaces.rdfinference.org/ril'
ANONYMOUS_FRAGMENT_BASE = 'anonymous:'

class RdfException(Exception):
    INTERNAL_ERROR = 0
    FEATURE_NOT_SUPPORTED = 1
    INVALID_FLAG = 2
    INVALID_CONTAINER_TYPE = 3
    INVALID_REGEX_STATEMENT = 4
    ABOUT_EACH_OBJECT_NOT_CONTAINER = 100

    def __init__(self, errorCode, *args):
        import MessageSource
        self.args = args
        self.errorCode = errorCode
        Exception.__init__(self, MessageSource.RDF_ERROR_MESSAGES[errorCode]%args)


class ParseException(Exception):
    FEATURE_NOT_SUPPORTED = 1
    INVALID_PREDICATE = 10
    INVALID_CONTAINER_PROPERTY = 20
    INVALID_CONTAINER_TYPE = 30
    MULTIPLE_VALUE_OBJECTS = 40
    NONEMPTY_PROPELT_WITH_PROPATTRS = 50

    def __init__(self, errorCode, *args):
        import MessageSource
        self.args = args
        self.errorCode = errorCode
        Exception.__init__(self, MessageSource.PARSE_ERROR_MESSAGES[errorCode]%args)



