import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Dictionary
from Ft.Ods.MetaData import CollectionKind
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_metadata_collection, test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)

    test_metadata_collection.Test(tester,Dictionary.Dictionary,is_ordered=0,collectionKind=CollectionKind.ck_dictionary)
    
    db = Database.Database()
    db.open(DBNAME)
    
    try:
        tester.startGroup("Dictionary Interface %s Driver" % tester.test_data['driver'])

        def GetType(db,values):
            return db.schema().resolve('pk_short')
        test_metadata_util.test_form_drop(tester,db,Dictionary.Dictionary,'key_type',GetType)

        tester.groupDone()

    finally:
        db.close()


