

odl_string = '''
module Test {

class Professor;

class Student (extent students)
{
	relationship Professor learns_from inverse Test::Professor :: teaches;
};

class Professor
{
	relationship ::Test::Student teaches inverse Student :: learns_from;
};
};

'''
#'

import test_util,os,sys

DBNAME=os.environ.get("ODS_TEST_DB","ods:test")


pClass = """class ProfessorImp(Professor.Professor_stub):
    g_professors = 0

    def __init__(self,db,data):
        Professor.Professor_stub.__init__(self,db,data)
        
        ProfessorImp.g_professors = ProfessorImp.g_professors + 1

    def __del__(self):
        ProfessorImp.g_professors = ProfessorImp.g_professors - 1
"""

sClass = """class StudentImp(Student.Student_stub):
    g_students = 0

    def __init__(self,db,data):
        Student.Student_stub.__init__(self,db,data)
        
        StudentImp.g_students = StudentImp.g_students + 1

    def __del__(self):
        global g_students

        StudentImp.g_students = StudentImp.g_students - 1
"""


def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')

def _Test(tester):
    from Ft.Ods import Database


    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import Professor
        from Test import Student
        reload(Professor)
        reload(Student)
    except:
        tester.error('Error in syntax', 1)
    tester.testDone()


    from Ft.Lib import Cyclops
    z = Cyclops.CycleFinder()

    gp = {'Professor':Professor}
    exec(pClass,gp)
    gs = {'Student':Student}
    exec(sClass,gs)
    ProfessorImp = gp['ProfessorImp']
    StudentImp = gs['StudentImp']
    
    #Create an instance and see if it goes away

    db = Database.Database()
    db.open(DBNAME)
    try:
        tester.startGroup("Memory %s Driver" % tester.test_data['driver'])

        tester.startTest("Creation")
        tx = db.new()
        tx.begin()

        z.register(tx)

        p = ProfessorImp(db,None)

        tx.commit()

        p = None

        tester.testResults(0,ProfessorImp.g_professors,done=0,msg="Wrong number or Professors")

        z.find_cycles()
        if len(z.cycles) != 0:
            z.show_cycles()
            tester.error("Should not be cycles")

        tester.testDone()

        tester.startTest("Do it with a relationship")
        z2 = Cyclops.CycleFinder()

        tx = db.new()
        tx.begin()

        z2.register(tx)

        p = ProfessorImp(db,None)
        s = StudentImp(db,None)

        s.learns_from = p

        tx.commit()

        s.drop_learns_from(p)
        p = None
        s = None

        tester.testResults(0,ProfessorImp.g_professors,done=0,msg="Wrong number or Professors")
        tester.testResults(0,StudentImp.g_students,done=0,msg="Wrong number of Students")
        z2.find_cycles()
        if len(z2.cycles) != 0:
            z2.show_cycles()
            tester.testError("Should not be cycles")

        tester.testDone()

        tester.groupDone()
    finally:

        db.close()


