#Ryan Laundry <rjlaundr@ericir.syr.edu> having trouble with SubProperty
import xml.dom.ext
from xml.dom.ext.reader import PyExpat
reader = PyExpat.Reader()

source_1 = """<?xml version="1.0"?>
<rdf:RDF
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"
>
  <rdf:Property rdf:ID="toolFor"> 
   <rdfs:label>Intermediary</rdfs:label> 
   <rdfs:comment>The group that would use the resource (e.g., a
teacher).</rdfs:comment> 
   <rdfs:subPropertyOf
rdf:resource="http://gemstar.ischool.washington.edu/GEM/1.0/gem#audience" /> 
  </rdf:Property>
</rdf:RDF>
"""

def Test():
    from Ft.Rdf.Drivers import Memory
    db = Memory.CreateDb('mydemo')

    from Ft.Rdf import Model, SchemaHandler, Statement
    from Ft.Rdf.Serializers.Dom import Serializer

    sh = SchemaHandler.SchemaHandler()
    m = Model.Model('http://spam.com', db, sh)

    s = Statement.Statement(
    'http://gemstar.ischool.washington.edu/GEM/1.0/gem#audience',
    'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
    'http://www.w3.org/1999/02/22-rdf-syntax-ns#Property'
    )
    #If you comment out this add, it will (rightly) bomb
    m.add(s)
    
    serializer = Serializer()
    
    schemadoc = reader.fromString(source_1)
    serializer.deserialize(m, schemadoc, 'http://schema.spam.com')

    print "Model with user's RDF schema read in\n"
    print m.complete(None, None, None)

    outdoc = serializer.serialize(m)
    xml.dom.ext.PrettyPrint(outdoc)
    xml.dom.ext.ReleaseNode(schemadoc)
    xml.dom.ext.ReleaseNode(outdoc)
    return


if __name__ == '__main__':
    Test()

