def Test(tester):

    tester.startGroup('Boolean Expressions')

    tester.startTest('Creating test environment')
    from xml.xpath import ParsedExpr
    from xml.utils import boolean

    from DummyExpr import boolT, boolF
    from DummyExpr import num3, numN4, num4p5
    from DummyExpr import strPi, strText
    
    tests = {ParsedExpr.ParsedRelationalExpr : [((0, strPi, numN4), boolean.false),
                                                ((1, strPi, numN4), boolean.false),
                                                ((2, strPi, numN4), boolean.true),
                                                ((3, strPi, strPi), boolean.true),
                                                ],
             ParsedExpr.ParsedEqualityExpr : [(('=', strPi, strPi), boolean.true),
                                              (('=', strPi, strText), boolean.false),
                                              (('!=', strPi, numN4), boolean.true),
                                              ],
             ParsedExpr.ParsedAndExpr : [((boolT, boolT), boolean.true),
                                         ((boolT, boolF), boolean.false),
                                         ((boolF, boolF), boolean.false),
                                         ],
             ParsedExpr.ParsedOrExpr : [((boolT, boolF), boolean.true),
                                        ((boolT, boolT), boolean.true),
                                        ((boolF, boolF), boolean.false),
                                        ]
             }
    
    tester.testDone()

    for (expr, boolTests) in tests.items():
        for (args, expected) in boolTests:
            p = apply(expr, args)
            tester.startTest('Comparing %s' % repr(p))
            result = p.evaluate(None)
            tester.compare(result, expected)
            tester.testDone()

    tester.groupDone()
