def Test(tester):

    tester.startGroup('Core Function Library')

    tester.startTest('Creating test environment')

    from xml import xpath
    from xml.xpath import ParsedExpr
    from xml.xpath import Context
    from xml.utils import boolean

    DomTree = tester.test_data['tree']
    context1 = Context.Context(DomTree.CHILD1,1,3)
    context2 = Context.Context(DomTree.CHILD2,2,3)

    import DummyExpr
    from DummyExpr import boolT, boolF
    from DummyExpr import num1, num3, numN4, num4p5
    from DummyExpr import strPi, strText, strPiText, strSpace

    nodeset0 = DummyExpr.DummyNodeSetExpr([])
    nodeset1 = DummyExpr.DummyNodeSetExpr([DomTree.ROOT])
    nodeset2 = DummyExpr.DummyNodeSetExpr([DomTree.ROOT, DomTree.CHILD1])
    nodeset3 = DummyExpr.DummyNodeSetExpr([DomTree.CHILD1])
    nodeset4 = DummyExpr.DummyNodeSetExpr([DomTree.CHILD3])

    strNodeset3 = '\n    \n    \n    Text1\n  '

    translateFrom = DummyExpr.DummyStringExpr('abcdefg')
    translateTo = DummyExpr.DummyStringExpr('ABCDEFG')

    tests = [('last', [], context1, 3),
             ('last', [], context2, 3),
             ('position', [], context1, 1),
             ('position', [], context2, 2),
             ('count', [nodeset2], context1, 2),
             ('id', [num1], context1, [DomTree.CHILD2]),
             ('local-name', [nodeset0], context1, ''),
             ('local-name', [nodeset4], context1, 'CHILD3'),
             ('namespace-uri', [nodeset0], context1, ''),
             ('namespace-uri', [nodeset4], context1, 'http://foo.com'),
             ('name', [nodeset4], context1, 'foo:CHILD3'),
             ('string', [nodeset3], context1, strNodeset3),
             ('concat', [nodeset3, strPi, strText], context1, strNodeset3 + '3.14Hi'),
             ('starts-with', [nodeset3, strPi], context1, boolean.false),
             ('starts-with', [nodeset3, nodeset3], context1, boolean.true),
             ('contains', [nodeset3, strPi], context1, boolean.false),
             ('contains', [nodeset3, nodeset3], context1, boolean.true),
             ('substring-before', [strPiText, strText], context1, '3.14'),
             ('substring-after', [strPiText, strPi], context1, 'Hi'),
             ('substring', [strPiText, strPi], context1, '14Hi'),
             ('substring', [strPiText, strPi, num1], context1, '1'),
             ('string-length', [strPiText], context1, 6),
             ('normalize-space', [strSpace], context1, 'Ht There Mike'),
             ('translate', [strSpace, translateFrom, translateTo], context1, 'Ht    \t ThErE\t   MikE'),
             ('boolean', [strPiText], context1, boolean.true),
             ('not', [strPiText], context1, boolean.false),
             ('true', [], context1, boolean.true),
             ('false', [], context1, boolean.false),
             ('number', [], context1, xpath.NaN),
             ('floor', [strPi], context1, 3),
             ('ceiling', [strPi], context1, 4),
             ('round', [strPi], context1, 3),
             ]

    tester.testDone()

    for (name, args, context, expected) in tests:
        p = apply(ParsedExpr.ParsedFunctionCallExpr, (name, args))
        tester.startTest('Evaluating %s' % repr(p))
        result = p.evaluate(context)
        try:
            tester.compare(expected,result)
        except:
            print repr(expected)
            print repr(result)
            raise
        tester.testDone()

    tester.groupDone()
