def PreprocessFiles(tester, dirs, files):
    ignored_dirs = []
    for dir in ignored_dirs:
        if dir in dirs:
            dirs.remove(dir)

    ordered_dirs = ['Core', 'Borrowed']
    position = 0
    for dir in ordered_dirs:
        if dir in dirs:
            dirs.remove(dir)
            dirs.insert(position, dir)
            position = position + 1

    return (dirs, files)
    

class _DomTree:
    def __init__(self, dom):
        from xml.dom import Node
        from xml.dom.ext import PrettyPrint
        self.DOM = dom
        self.PI = dom.firstChild
        self.ROOT = dom.documentElement
        comment = self.ROOT.firstChild
        while comment and comment.nodeType != Node.COMMENT_NODE:
            comment = comment.nextSibling
        self.COMMENT = comment
        self.CHILDREN = filter(lambda node, type=Node.ELEMENT_NODE:
                               node.nodeType == type,
                               self.ROOT.childNodes)

        self.CHILD1 = self.CHILDREN[0]
        self.ATTR1 = self.CHILD1.getAttributeNodeNS('', 'attr1')
        self.GCHILDREN1 = filter(lambda node, type=Node.ELEMENT_NODE:
                                 node.nodeType == type,
                                 self.CHILD1.childNodes)
        self.GCHILD11 = self.GCHILDREN1[0]
        self.GCHILD12 = self.GCHILDREN1[1]
        self.TEXT1 = self.CHILD1.lastChild

        self.CHILD2 = self.CHILDREN[1]
        self.ATTR2 = self.CHILD2.getAttributeNodeNS('', 'attr1')
        self.GCHILDREN2 = filter(lambda node, type=Node.ELEMENT_NODE:
                                 node.nodeType == type,
                                 self.CHILD2.childNodes)
        self.GCHILD21 = self.GCHILDREN2[0]
        self.GCHILD22 = self.GCHILDREN2[1]

        self.CHILD3 = self.CHILDREN[2]
        self.ATTR3 = self.CHILD3.getAttributeNodeNS('http://foo.com', 'name')

        self.PI2 = dom.lastChild

# Assume that all DOMs are available
from Ft.Lib import cDomlette, pDomlette
from xml.dom.ext.reader import Sax2
from xml.dom import minidom
from xml import sax

xml = """
<?xml-stylesheet "Data" ?>
<ROOT>
  <!-- Test Comment -->
  <CHILD1 attr1="val1" >
    <GCHILD name="GCHILD11"/>
    <GCHILD name="GCHILD12"/>
    Text1
  </CHILD1>
  <CHILD2 attr1="val2" ID="1">
    <GCHILD name="GCHILD21"/>
    <GCHILD name="GCHILD22"/>
  </CHILD2>
  <foo:CHILD3 xmlns:foo="http://foo.com" foo:name="mike"/>
</ROOT>
<?no-data ?>
"""

_DomMapping = {
    'cDomlette' : _DomTree(cDomlette.RawExpatReader().fromString(xml)),
    'pDomlette' : _DomTree(pDomlette.PyExpatReader().fromString(xml)),
    '4DOM' : _DomTree(Sax2.FromXml(xml)),
    'minidom' : _DomTree(minidom.parseString(xml)),
    }




from Ft.Lib.TestSuite import TestWalker

class XPathMode(TestWalker.TestMode):
    def __init__(self):
        TestWalker.TestMode.__init__(self,self.modeName,self.default)

    def _init(self,tester):
        return 1

    def _pre(self,tester):
        tester.test_data['tree'] = _DomMapping[self.modeName]
        tester.test_data['reader'] = self.reader
        
class _cDomletteMode(XPathMode):
    modeName = 'cDomlette'
    default = 0
    reader = cDomlette.RawExpatReader()

class _pDomletteMode(XPathMode):
    modeName = 'pDomlette'
    default = 1
    reader = pDomlette.PyExpatReader()

class _4DOMMode(XPathMode):
    modeName = '4DOM'
    default = 0
    reader = Sax2.Reader()
    
class _minidomMode(XPathMode):
    modeName = 'minidom'
    default = 0
    #reader = minidom

    def _init(self,tester):
        tester.warning("minidom does not support comments, needed for testing")
        return 0


# minidom does not support comments, needed for testing
MODES = [_pDomletteMode(), _cDomletteMode(), _4DOMMode(), _minidomMode(),
         ]
