

#From the spec (and a few more)
pointers = [('xpointer(id("list37")/item)',
             'xpointer(id("list37")/child::item)'),
            ('xpointer(id("list37")/item[1]/range-to(following-sibling::item[2]))',
             'xpointer(id("list37")/child::item[1]/range-to(following-sibling::item[2]))'),
            ('xpointer(id("chap1"))xpointer(//*[@id="chap1"])',
             'xpointer(id("chap1")) xpointer(/descendant-or-self::node()/child::*[attribute::id = "chap1"])'),
            ('intro',
             'intro'),
            ('xpointer(id("intro"))',
             'xpointer(id("intro"))'),
            ('intro/14/3',
             'intro/14/3'),
            ('/1/2/5/14/3',
             '/1/2/5/14/3'),
            ('xpointer(//x:a)',
             'xpointer(/descendant-or-self::node()/child::x:a)'),
            ('xmlns(x=http://example.com/foo) xpointer(//x:a)',
             'xmlns(x=http://example.com/foo) xpointer(/descendant-or-self::node()/child::x:a)'),
            ('xmlns(x=http://example.com/foo) xmlns(y=http://examples.org/bar) xpointer(//x:a/y:a)',
             'xmlns(x=http://example.com/foo) xmlns(y=http://examples.org/bar) xpointer(/descendant-or-self::node()/child::x:a/child::y:a)'),
            ('xpointer(id("chap1")/range-to(id("chap2")))',
             'xpointer(id("chap1")/range-to(id("chap2")))'),
            ('xpointer(descendant::REVST/range-to(following::REVEND[1]))',
             'xpointer(descendant::REVST/range-to(following::REVEND[1]))'),
            ('xpointer(string-range(//title,"Thomas Pynchon")[17])',
             'xpointer(string-range(/descendant-or-self::node()/child::title, "Thomas Pynchon")[17])'),
            ('xpointer(string-range(//title,"Thomas Pynchon",8,0)[3])',
             'xpointer(string-range(/descendant-or-self::node()/child::title, "Thomas Pynchon", 8, 0)[3])'),
            ('xpointer(string-range(string-range(//P,"Thomas Pynchon")[3],"P",1,0))',
             'xpointer(string-range(string-range(/descendant-or-self::node()/child::P, "Thomas Pynchon")[3], "P", 1, 0))'),
            ('xpointer(string-range(/,"!",1,2)[5])',
             'xpointer(string-range(/, "!", 1, 2)[5])'),
            ('xpointer(here()/ancestor::slide[1]/preceding::slide[1])',
             'xpointer(here()/ancestor::slide[1]/preceding::slide[1])'),
            ('xmlns(x=foo.com) xpointer(1)',
             'xmlns(x=foo.com) xpointer(1)'),
            ('xpointer(range-to(range-to(foo)))',
             'xpointer(range-to(range-to(child::foo)))'),
            ]


from Ft.XPointer import XPointerParser
from Ft.XPointer import XPointerParserc
parsers = [XPointerParserc]

def Test(tester):
    for parser in parsers:
        tester.startGroup(parser.__name__)
        for ptr, expected in pointers:
            tester.startTest(ptr)
            result = XPointerParserc.new().parse(ptr)
            tester.compare(expected, repr(result))
            tester.testDone()
        tester.groupDone()
    return
