#This source doc used to bomb cDomlette just on parse, as Uche found out

from Xslt import test_harness

sheet_1 = """\
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
"""

source_1 = """\
<?xml version='1.0'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
  <xi:include href="file:Lib/include1.xml"/>
</x>
"""

expected_1 = """\
<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
  
<foo/>
</x>"""


source_2 = """\
<?xml version='1.0'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
  <xi:include href="file:Lib/include2.xml"/>
</x>
"""

expected_2 = """\
<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
  
<foo>
  
<foo/>
</foo>
</x>"""


source_3 = """\
<?xml version='1.0'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
  <xi:include href="file:Lib/include2.xml" parse='text'/>
</x>
"""

expected_3 = """\
<?xml version='1.0' encoding='UTF-8'?>
<x xmlns:xi="http://www.w3.org/2001/XInclude">
  &lt;?xml version='1.0' encoding='utf-8'?>
&lt;foo xmlns:xi="http://www.w3.org/2001/XInclude">
  &lt;xi:include href="include1.xml"/>
&lt;/foo>
</x>"""

def Test(tester):
    source_type = tester.test_data['source']
    #if source_type not in ['default', 'pDomlette']:
    if source_type not in ['pDomlette']:
        tester.warning("XInclude not supported except using pDomletteReader (current testing mode: %s)" %
                       source_type)
        return

    tester.startGroup("Case 1")
    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Case 2")
    source = test_harness.FileInfo(string=source_2)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_2,
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Case 3")
    source = test_harness.FileInfo(string=source_3)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_3,
                                    )
    xtest.test(tester)
    tester.groupDone()

    return
