from Xslt import test_harness

sheet_1 = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ft="http://xmlns.4suite.org/ext"
  extension-element-prefixes="ft"
  version="1.0"
  >

  <xsl:output method="text"/>
  
  <xsl:template match="/">
    <xsl:variable name='matches' select="ft:search-re('([a-z])([0-9])', 'a1b2c3d')"/>
    <xsl:apply-templates select='$matches'/>
  </xsl:template>

  <xsl:template match="Match">
    <xsl:text>Match 1 groups:</xsl:text><xsl:apply-templates/><xsl:text>&#10;</xsl:text>
  </xsl:template>
  
  <xsl:template match="Group">
    <xsl:text> "</xsl:text><xsl:apply-templates/><xsl:text>"</xsl:text>
  </xsl:template>
  
</xsl:stylesheet>
"""

##from Eric van der Vlist
##preg_match_all("Call 555-1212 or 1-800-555-1212 or (612) 555-1313",
##"/\(? (\d{3})? \)? (?(1) [\-\s] ) \d{3}-\d{4}/x")

##would return a nodeset whose structure could be:
##<Match>
##  <Group></Group>
##  <Group></Group>
##  <Group>555-1212</Group>
##</Match>
##<Match>
##  <Group>1</Group>
##  <Group>-800-</Group>
##  <Group>5551212</Group>
##</Match>
##<Match>
##  <Group></Group>
##  <Group>(612) </Group>
##  <Group>555-1213</Group>
##</Match>

sheet_2 = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ft="http://xmlns.4suite.org/ext"
  extension-element-prefixes="ft"
  version="1.0"
  >

  <xsl:output method="text"/>
  
  <xsl:template match="/">
    <xsl:variable name='matches' select="ft:search-re('(1)?([(-]?\d{3}?[)-]?\s?)?(\d{3}-\d{4})', 'Call 555-1212 or 1-800-555-1212 or (612) 555-1313')"/>
    <xsl:apply-templates select='$matches'/>
  </xsl:template>

  <xsl:template match="Match">
    <xsl:text>Match 1 groups: "</xsl:text>
    <xsl:for-each select="Group">
      <xsl:apply-templates/>
    </xsl:for-each>
    <xsl:text>"&#10;</xsl:text>
  </xsl:template>
  
</xsl:stylesheet>
"""

source_1 = """<dummy/>"""

expected_1 = """Match 1 groups: "a" "1"
Match 1 groups: "b" "2"
Match 1 groups: "c" "3"
"""

expected_2 = """Match 1 groups: "555-1212"
Match 1 groups: "1-800-555-1212"
Match 1 groups: "(612) 555-1313"
"""

def Test(tester):

    tester.startGroup("ft:search-re, simple REGEX")
    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    compareFunc=cmp
                                    )

    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("ft:search-re, complex REGEX")

    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_2)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_2,
                                    compareFunc=cmp
                                    )

    xtest.test(tester)
    tester.groupDone()

    return
