from Xslt import test_harness


expected_1 = """<HTML>
  <HEAD>
    <meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>
    <TITLE>Address Book</TITLE>
  </HEAD>
  <BODY>
    <H1>Tabulate just the Names</H1>
    <TABLE>
      <TR>
        <TD ALIGN='CENTER'>
          <B ID='pieter.aaron@inter.net'>Pieter Aaron</B>
        </TD>
      </TR>
      <TR>
        <TD ALIGN='CENTER'>
          <B ID='endubuisi@spamtron.com'>Emeka Ndubuisi</B>
        </TD>
      </TR>
      <TR>
        <TD ALIGN='CENTER'>
          <B ID='vxz@magog.ru'>Vasia Zhugenev</B>
        </TD>
      </TR>
    </TABLE>
  </BODY>
</HTML>"""

sheet_2 = """\
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <xsl:variable name="sty-doc" select="document('')"/>

  <xsl:key name='name' match='*' use='name()'/>

  <xsl:template match="/">
    <xsl:for-each select=".">
      Entries from keys: <xsl:value-of select="count(key('name', 'ENTRY'))"/>
      Template from keys: <xsl:value-of select="count(key('name', 'xsl:template'))"/>
    </xsl:for-each>
    <xsl:for-each select="$sty-doc">
      Entries from keys: <xsl:value-of select="count(key('name', 'ENTRY'))"/>
      Template from keys: <xsl:value-of select="count(key('name', 'xsl:template'))"/>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
"""

expected_2 = """\
<?xml version='1.0' encoding='UTF-8'?>

      Entries from keys: 3
      Template from keys: 0
      Entries from keys: 0
      Template from keys: 1"""


def Test(tester):
    tester.startGroup("Basic keys test")

    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(uri="Xslt/Core/addr_book_keyed.xsl")
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )

    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Test keys shifting with context doc")

    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(string=sheet_2)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_2,
                                    compareFunc = cmp,
                                   )

    xtest.test(tester)
    tester.groupDone()
    return
