from Xslt import test_harness
from Ft import __version__
import os

sheet_str = """<?xml version="1.0"?>
<xsl:transform
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ft="http://xmlns.4suite.org"
  xmlns:env="http://xmlns.4suite.org/xslt/env-system-property"
  version="1.0"
>
  <xsl:template match="/">
    <xsl:value-of select="system-property('xsl:vendor')"/><xsl:text>&#10;</xsl:text>
    <xsl:value-of select="system-property('xsl:vendor-url')"/><xsl:text>&#10;</xsl:text>
    <xsl:value-of select="system-property('xsl:version')"/><xsl:text>&#10;</xsl:text>
    <xsl:value-of select="system-property('ft:version')"/><xsl:text>&#10;</xsl:text>
    <xsl:value-of select="system-property('env:PATH')"/><xsl:text>&#10;</xsl:text>
  </xsl:template> 

</xsl:transform>"""

xml_source = """<dummy/>"""


expected = """<?xml version='1.0' encoding='UTF-8'?>
Fourthought Inc.
http://4Suite.org
1
%s
%s
"""%(__version__, os.environ.get('PATH', ''))


def Test(tester):

    tester.startGroup("system-property")

    source = test_harness.FileInfo(string=xml_source)
    sty = test_harness.FileInfo(string=sheet_str)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected,
                                    compareFunc=cmp,
                                    )

    xtest.test(tester)
    tester.groupDone()
    return
