import time

from Ft.Xml.Xslt import Stylesheet

from Ft.Server.Common import ResourceTypes, ValidationInfo

from Ft.Server.Server import FtServerServerException, Error

import test_helper

def test_create(tester):


    tester.startTest("Create Schematron Document")

    repo = repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    schema = test.createDocument('schema1',SCHEMA1, forcedType = ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT)
    tester.compare(ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT,test.hasResource('schema1'))
    tester.compare(schema,test.fetchResource('schema1'))
    tester.compare(ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT,schema.getResourceType())
    tester.compare(1,schema.isResourceType(ResourceTypes.ResourceType.RAW_FILE))
    tester.compare(1,schema.isResourceType(ResourceTypes.ResourceType.XML_DOCUMENT))
    tester.compare(1,schema.isResourceType(ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT))
    tester.compare(0,schema.isResourceType(ResourceTypes.ResourceType.CONTAINER))
    repo.txCommit()

    repo = repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    tester.compare(ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT,test.hasResource('schema1'))
    repo.txRollback()

    repo = repo = test_helper.GetRepo(tester)
    schema = repo.fetchResource('/test/schema1')
    test = repo.fetchResource('/test')
    tester.compare(test,schema.getParent())
    repo.txRollback()
                 
    tester.testDone()
    return



def test_access(tester):

    tester.startTest("Schematron Document Access")

    repo = repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/schema1')
    tester.compare('text/xml',sheet.getImt())
    tester.compare(SCHEMA1,sheet.getContent())
    vi = sheet.getValidationInfo()
    test_helper.CompareValidationInfo(tester,ValidationInfo.NoValidation(),vi)
    #Just call, don't test
    sheet.getCreationDate()
    sheet.getLastModifiedDate()
    repo.txRollback()
    
    tester.testDone()


def test_modify(tester):

    tester.startTest("Schematron Document Modification")

    repo = repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/schema1')
    lmd = sheet.getLastModifiedDate()
    time.sleep(1)
    sheet.setContent(SCHEMA2)
    tester.compare(SCHEMA2,sheet.getContent())
    repo.txCommit()

    repo = repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/schema1')
    tester.compare(SCHEMA2,sheet.getContent())
    tester.compare(1,sheet.getLastModifiedDate() > lmd)
    repo.txRollback()

    
    tester.testDone()



def test_delete(tester):

    tester.startTest("Delete Schematron Document")
    repo = repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource('/test/schema1')
    test = sheet.getParent()
    sheet.delete()
    tester.compare(0,test.hasResource('schema1'))
    tester.testException(sheet.getContent,(),FtServerServerException,{'code':Error.OBJECT_DELETED})
    repo.txCommit()

    repo = repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    tester.compare(0,test.hasResource('schema1'))
    repo.txRollback()

    tester.testDone()

def test_xml_interfaces(tester):

    tester.startTest("Schematron Document to Schematron")
    repo = repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    schema1 = test.createDocument('schema1',SCHEMA1,forcedType = ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT)

    dom = schema1.asSchematron()
    tester.compare(1,hasattr(dom,'expandedName'))
    repo.txRollback()
    tester.testDone()





def cleanup(tester):

    tester.startTest("Clean Up")
    repo = repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        repo.deleteResource('/test')
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()



SCHEMA1="""<schema xmlns='http://www.ascc.net/xml/schematron'>
    
  <pattern name='Root'>
    <rule context="/docelem">
      <assert test='@v'>
        VALIDATION ERROR: The root element must have a v attribute
      </assert>      
    </rule>
  </pattern>
  
</schema>"""

SCHEMA2="""<schema xmlns='http://www.ascc.net/xml/schematron'>
    
  <pattern name='Root'>
    <rule context="/docelem">
      <assert test='@w'>
        VALIDATION ERROR: The root element must have a v attribute
      </assert>      
    </rule>
  </pattern>
  
</schema>"""

def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_access(tester)
    test_modify(tester)
    test_delete(tester)
    test_xml_interfaces(tester)


