
from Ft.Xml.Lib import TreeCompare

import test_helper


def test_raw_file(tester):
    tester.startTest("Raw File set content")
    repo = test_helper.GetRepo(tester)
    rf = repo.fetchResource('/test/rf1')
    rf.setContent(RAW2)
    tester.compare(RAW2,rf.getContent())
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    rf = repo.fetchResource('/test/rf1')
    tester.compare(RAW2,rf.getContent())
    repo.txRollback()
    tester.testDone()

def test_xml_document(tester):
    tester.startTest("XML Document set content")
    repo = test_helper.GetRepo(tester)
    res = repo.fetchResource('/test/doc1')
    res.setContent(DOC2)
    tester.compare(DOC2,res.getContent())
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    res = repo.fetchResource('/test/doc1')
    tester.compare(DOC2,res.getContent())
    repo.txRollback()
    tester.testDone()


def test_xslt_document(tester):
    tester.startTest("XSLT Document set content")
    repo = test_helper.GetRepo(tester)
    res = repo.fetchResource('/test/xslt1')
    res.setContent(SHEET2)
    tester.compare(SHEET2,res.getContent())
    tester.compare(EXPECTED1,repo.fetchResource('/test/doc1').applyXslt([res])[0])
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    res = repo.fetchResource('/test/xslt1')
    tester.compare(EXPECTED1,repo.fetchResource('/test/doc1').applyXslt([res])[0])
    tester.compare(SHEET2,res.getContent())

    repo.txRollback()
    tester.testDone()


def test_rdf_document(tester):
    tester.startTest("RDF Document set content")
    repo = test_helper.GetRepo(tester)
    res = repo.fetchResource('/test/rdf1')
    res.setContent(RDF2)
    tester.compare(EXPECTED2,res.getContent(), func=TreeCompare.TreeCompare)
    tester.compare(1,len(repo.getModel().complete('http://www.dlib.org',
                                                  'http://purl.org/metadata/dublin_core#Date',
                                                  '2001-11-16',
                                                  scope = 'ftss:///test/rdf1')))
    tester.compare(0,len(repo.getModel().complete('http://www.dlib.org',
                                                  'http://purl.org/metadata/dublin_core#Date',
                                                  '1995-01-07',
                                                  scope = 'ftss:///test/rdf1')))
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    res = repo.fetchResource('/test/rdf1')
    tester.compare(EXPECTED2,res.getContent(), func=TreeCompare.TreeCompare)
    tester.compare(1,len(repo.getModel().complete('http://www.dlib.org',
                                                  'http://purl.org/metadata/dublin_core#Date',
                                                  '2001-11-16',
                                                  scope = 'ftss:///test/rdf1')))

    tester.compare(0,len(repo.getModel().complete('http://www.dlib.org',
                                                  'http://purl.org/metadata/dublin_core#Date',
                                                  '1995-01-07',
                                                  scope = 'ftss:///test/rdf1')))
    repo.txRollback()
    tester.testDone()


def test_schematron_document(tester):
    tester.startTest("Schematron Document set content")
    tester.warning("not tested")
    tester.testDone()

def test_container(tester):
    tester.startTest("Container Document set content")
    tester.warning("not tested")
    tester.testDone()

def test_alias(tester):
    tester.startTest("Alias Document set content")
    tester.warning("not tested")
    tester.testDone()

def test_command(tester):
    tester.startTest("Command Document set content")
    tester.warning("not tested")
    tester.testDone()

def test_server(tester):
    tester.startTest("Server Document set content")
    tester.warning("not tested")
    tester.testDone()

def test_xpath_document_definition(tester):
    tester.startTest("XPath Document Definition set content")
    tester.warning("not tested")
    tester.testDone()

def test_xslt_document_definition(tester):
    tester.startTest("Xslt Document Definition set content")
    tester.warning("not tested")
    tester.testDone()

def test_user(tester):
    tester.startTest("User Document set content")
    tester.warning("not tested")
    tester.testDone()

def test_group(tester):
    tester.startTest("Group Document set content")
    tester.warning("not tested")
    tester.testDone()

def test_meta_data(tester):
    tester.startTest("Meta Data Document set content")
    tester.warning("not tested")
    tester.testDone()

def test_uri_reference_file(tester):
    tester.startTest("URI Reference File set content")
    tester.warning("not tested")
    tester.testDone()



RAW1="RAW1"
RAW2="RAW2"

DOC1="""<docelem v='foo'/>"""
DOC2="""<docelem2 v='foo'/>"""

SHEET1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method='text'/>
  <xsl:template match="/">
  Sheet 1
  </xsl:template>
</xsl:stylesheet>"""

SHEET2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method='text'/>
  <xsl:template match="/">
  Sheet 2
  </xsl:template>
</xsl:stylesheet>"""

EXPECTED1 = """\n  Sheet 2\n  """

RDF1 = """<rdf:RDF
    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
    xmlns:dc='http://purl.org/metadata/dublin_core#'>
    <rdf:Description about='http://www.dlib.org'>
      <dc:Date>1995-01-07</dc:Date>
    </rdf:Description>
  </rdf:RDF>
"""

RDF2 = """<rdf:RDF
    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
    xmlns:dc='http://purl.org/metadata/dublin_core#'>
    <rdf:Description about='http://www.dlib.org'>
      <dc:Date>2001-11-16</dc:Date>
    </rdf:Description>
  </rdf:RDF>
"""

EXPECTED2="""<?xml version='1.0' encoding='UTF-8'?>\n<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:ns1='http://purl.org/metadata/dublin_core#'>\n  <rdf:Description rdf:about='http://www.dlib.org'>\n    <ns1:Date>2001-11-16</ns1:Date>\n  </rdf:Description>\n</rdf:RDF>\n"""



SCHEMA1="""<schema xmlns='http://www.ascc.net/xml/schematron'>

  <pattern name='Root'>
    <rule context="/docelem">
      <assert test='@v'>
        VALIDATION ERROR: The root element must have a v attribute
      </assert>
    </rule>
  </pattern>

</schema>"""

SCHEMA2="""<schema xmlns='http://www.ascc.net/xml/schematron'>

  <pattern name='Root'>
    <rule context="/docelem">
      <assert test='@w'>
        VALIDATION ERROR: The root element must have a v attribute
      </assert>
    </rule>
  </pattern>

</schema>"""

USER1 = """<ft:User xmlns:ft='http://xmlns.4suite.org/reserved' name='test'
>
  <ft:passhash><![CDATA[dc76e9f0c0006e8f919e0c515c66dbba3982f785]]></ft:passhash>
  <ft:data>
  </ft:data>
</ft:User>"""

USER2 = """<ft:User xmlns:ft='http://xmlns.4suite.org/reserved' name='test'
>
  <ft:passhash><![CDATA[dc76e9f0c0006e8f919e0c515c66dbba3982f785]]></ft:passhash>
  <ft:data>
    <foo>bar</foo>
  </ft:data>
</ft:User>"""

DOCDEF1 = """<?xml version='1.0' encoding='UTF-8'?><ft:DocDef xmlns:ft='http://xmlns.4suite.org/reserved' name='test-def'><ft:CreationParams DocumentClass='XML_DOCUMENT' FullTextIndex='0'><ft:Validator type='NONE'/></ft:CreationParams></ft:DocDef>"""

DOCDEF2 = """<?xml version='1.0' encoding='UTF-8'?><ft:DocDef xmlns:ft='http://xmlns.4suite.org/reserved' name='test-def'><ft:CreationParams DocumentClass='XML_DOCUMENT' FullTextIndex='1'><ft:Validator type='NONE'/></ft:CreationParams></ft:DocDef>"""



def init(tester):
    repo = test_helper.GetRepo(tester)
    tester.startTest("Init")
    if repo.hasResource('/test'):
        repo.deleteResource('/test')

    test = repo.createContainer('/test')
    test.createRawFile('rf1','text/plain',RAW1)
    test.createDocument('doc1',DOC1)
    test.createDocument('xslt1',SHEET1)
    test.createDocument('rdf1',RDF1)

    repo.txCommit()
    tester.testDone()

def Test(tester):

    init(tester)
    test_raw_file(tester)
    test_xml_document(tester)
    test_xslt_document(tester)
    test_rdf_document(tester)
    test_schematron_document(tester)
    test_container(tester)
    test_alias(tester)
    test_command(tester)
    test_server(tester)
    test_xpath_document_definition(tester)
    test_xslt_document_definition(tester)
    test_user(tester)
    test_group(tester)
    test_meta_data(tester)
    test_uri_reference_file(tester)





