# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobStatistics(Model):
    """The Data Lake Analytics job execution statistics.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar last_update_time_utc: the last update time for the statistics.
    :vartype last_update_time_utc: datetime
    :ivar finalizing_time_utc: the job finalizing start time.
    :vartype finalizing_time_utc: datetime
    :ivar stages: the list of stages for the job.
    :vartype stages: list of :class:`JobStatisticsVertexStage
     <azure.mgmt.datalake.analytics.job.models.JobStatisticsVertexStage>`
    """ 

    _validation = {
        'last_update_time_utc': {'readonly': True},
        'finalizing_time_utc': {'readonly': True},
        'stages': {'readonly': True},
    }

    _attribute_map = {
        'last_update_time_utc': {'key': 'lastUpdateTimeUtc', 'type': 'iso-8601'},
        'finalizing_time_utc': {'key': 'finalizingTimeUtc', 'type': 'iso-8601'},
        'stages': {'key': 'stages', 'type': '[JobStatisticsVertexStage]'},
    }

    def __init__(self):
        self.last_update_time_utc = None
        self.finalizing_time_utc = None
        self.stages = None
