# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class AllocationMethod(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Allocation method.
    """

    DYNAMIC = "Dynamic"
    STATIC = "Static"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class CreateDiffDisk(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets a value indicating diff disk.
    """

    FALSE = "false"
    TRUE = "true"

class DynamicMemoryEnabled(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets a value indicating whether to enable dynamic memory or not.
    """

    FALSE = "false"
    TRUE = "true"

class InventoryType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The inventory type.
    """

    CLOUD = "Cloud"
    VIRTUAL_NETWORK = "VirtualNetwork"
    VIRTUAL_MACHINE_TEMPLATE = "VirtualMachineTemplate"
    VIRTUAL_MACHINE = "VirtualMachine"

class IsCustomizable(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets a value indicating whether the vm template is customizable or not.
    """

    FALSE = "false"
    TRUE = "true"

class LimitCpuForMigration(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets a value indicating whether to enable processor compatibility mode for live
    migration of VMs.
    """

    FALSE = "false"
    TRUE = "true"

class OsType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the different types of VM guest operating systems.
    """

    WINDOWS = "Windows"
    LINUX = "Linux"
    OTHER = "Other"
