# Copyright (c) 2000 Phil Thompson <phil@river-bank.demon.co.uk>


from qt import QPixmap, QFileDialog, QFileIconProvider


# Convert all the XPM icons to QPixmaps.

IconOpenXPM = [
    '22 22 5 1',
    '  c Gray100',
    '. c Yellow',
    'X c #848200',
    'o c Gray0',
    'O c None',
    'OOOOOOOOOOOOOOOOOOOOOO',
    'OOOOOOOOOOOOOOOOOOOOOO',
    'OOOOOOOOOOOOOOOOOOOOOO',
    'OOOOOOOOOOOOooooOOOOoO',
    'OOOOOOOOOOOoOOOOooOooO',
    'OOOOOOOOOOOOOOOOOOoooO',
    'OOOOOOOOOOOOOOOOOooooO',
    'OooooOOOOOOOOOOOoooooO',
    'o. . ooooooooooOOOOOOO',
    'o . . . . . . oOOOOOOO',
    'o. . . . . . .oOOOOOOO',
    'o . . . . . . oOOOOOOO',
    'o. . . ooooooooooooooo',
    'o . . ooXXXXXXXXXXXXoo',
    'o. . ooXXXXXXXXXXXXooO',
    'o . ooXXXXXXXXXXXXooOO',
    'o. ooXXXXXXXXXXXXooOOO',
    'o ooXXXXXXXXXXXXooOOOO',
    'oooXXXXXXXXXXXXooOOOOO',
    'ooXXXXXXXXXXXXooOOOOOO',
    'oooooooooooooooOOOOOOO',
    'OOOOOOOOOOOOOOOOOOOOOO'
]

IconOpen = QPixmap(IconOpenXPM)


IconWhatsThisXPM = [
    '16 16 3 1',
    '   c None',
    'o  c #000000',
    'a  c #000080',
    'o        aaaaa  ',
    'oo      aaa aaa ',
    'ooo    aaa   aaa',
    'oooo   aa     aa',
    'ooooo  aa     aa',
    'oooooo  a    aaa',
    'ooooooo     aaa ',
    'oooooooo   aaa  ',
    'ooooooooo aaa   ',
    'ooooo     aaa   ',
    'oo ooo          ',
    'o  ooo    aaa   ',
    '    ooo   aaa   ',
    '    ooo         ',
    '     ooo        ',
    '     ooo        '
]

IconWhatsThis = QPixmap(IconWhatsThisXPM)


IconDirOpenXPM = [
    '16 16 6 1',
    '. c None',
    'b c #ffff00',
    'd c #000000',
    '* c #999999',
    'c c #cccccc',
    'a c #ffffff',
    '................',
    '................',
    '...*****........',
    '..*aaaaa*.......',
    '.*abcbcba******.',
    '.*acbcbcaaaaaa*d',
    '.*abcbcbcbcbcb*d',
    '*************b*d',
    '*aaaaaaaaaa**c*d',
    '*abcbcbcbcbbd**d',
    '.*abcbcbcbcbcd*d',
    '.*acbcbcbcbcbd*d',
    '..*acbcbcbcbb*dd',
    '..*************d',
    '...ddddddddddddd',
    '................'
]

IconDirOpen = QPixmap(IconDirOpenXPM)


IconDirClosedXPM = [
    '16 16 6 1',
    '. c None',
    'b c #ffff00',
    'd c #000000',
    '* c #999999',
    'a c #cccccc',
    'c c #ffffff',
    '................',
    '................',
    '..*****.........',
    '.*ababa*........',
    '*abababa******..',
    '*cccccccccccc*d.',
    '*cbababababab*d.',
    '*cabababababa*d.',
    '*cbababababab*d.',
    '*cabababababa*d.',
    '*cbababababab*d.',
    '*cabababababa*d.',
    '*cbababababab*d.',
    '**************d.',
    '.dddddddddddddd.',
    '................'
]

IconDirClosed = QPixmap(IconDirClosedXPM)


IconFilePythonXPM = [
    '16 15 7 1',
    '. c #000000',
    '# c #00ff00',
    'a c #ff0000',
    'b c None',
    'c c #ffff00',
    'd c #808000',
    'e c #0000ff',
    'bbbbb..bbbbbbbbb',
    'bbbb.ddbbbbbbbbb',
    'bbbb...dbbbbbbbb',
    'bbbbc.e.bbbbbbbb',
    'bbbb.d.d.bbbbbbb',
    'b.ddddddd.dbbbbb',
    'b.dddd###.dbbbbb',
    'bbb###.#d##bbbbb',
    'bbb.a.##d##bbbbb',
    'bbbabb.b##dbbbbb',
    'bbbbbbb#ddbbbbbb',
    'bbbb.d#dd..b.bbb',
    'bbbb.#dd.ddbd..b',
    'bbbb##ddddddbbbb',
    'bbbbbd##b##bbbbb'
]

IconFilePython = QPixmap(IconFilePythonXPM)


IconFileMiscXPM = [
    '16 16 5 1',
    '. c #7f7f7f',
    '# c None',
    'c c #000000',
    'b c #bfbfbf',
    'a c #ffffff',
    '################',
    '..........######',
    '.aaaaaaaab.#####',
    '.aaaaaaaaba.####',
    '.aaaaaaaacccc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.aaaaaaaaaabc###',
    '.bbbbbbbbbbbc###',
    'ccccccccccccc###'
]

IconFileMisc = QPixmap(IconFileMiscXPM)


IconRunXPM = [
    '16 16 2 1',
    '. c None',
    '# c #000000',
    '................',
    '................',
    '................',
    '................',
    '............#...',
    '...###########..',
    '..##........#...',
    '..#.............',
    '..#.............',
    '..##............',
    '...#............',
    '................',
    '................',
    '................',
    '................',
    '................'
]

IconRun = QPixmap(IconRunXPM)


IconContinueXPM = [
    '16 16 2 1',
    '. c None',
    '# c #000000',
    '................',
    '................',
    '................',
    '................',
    '........#.......',
    '...#######..#...',
    '..##....#...##..',
    '..#..........#..',
    '..#..........#..',
    '..##...#....##..',
    '...#..#######...',
    '.......#........',
    '................',
    '................',
    '................',
    '................'
]

IconContinue = QPixmap(IconContinueXPM)


IconStepXPM = [
    '16 16 2 1',
    '. c None',
    '# c #000000',
    '................',
    '................',
    '................',
    '...##...........',
    '...####.........',
    '...######.......',
    '...########.....',
    '...##########...',
    '...##########...',
    '...########.....',
    '...######.......',
    '...####.........',
    '...##...........',
    '................',
    '................',
    '................'
]

IconStep = QPixmap(IconStepXPM)


IconStepIntoXPM = [
    '16 16 2 1',
    '. c None',
    '# c #000000',
    '................',
    '................',
    '.#......#.......',
    '.##.....##......',
    '.###....###.....',
    '.####...####....',
    '.#####..#####...',
    '.######.######..',
    '.######.######..',
    '.#####..#####...',
    '.####...####....',
    '.###....###.....',
    '.##.....##......',
    '.#......#.......',
    '................',
    '................'
]

IconStepInto = QPixmap(IconStepIntoXPM)


IconBreakXPM = [
    '19 17 3 1',
    ' 	c None',
    '_	c white',
    '# 	c red4',
    '                   ',
    '      #######      ',
    '     #########     ',
    '    ###########    ',
    '   #############   ',
    '  ###############  ',
    '  #_________#___#  ',
    '  #_###_#_#_#_#_#  ',
    '  #___#_#_#_#_#_#  ',
    '  ###_#_#_#_#___#  ',
    '  #___#_#___#_###  ',
    '  ###############  ',
    '   #############   ',
    '    ###########    ',
    '     #########     ',
    '      #######      ',
    '                   '
]

IconBreak = QPixmap(IconBreakXPM)


# Set the icon provider.

class IconProvider(QFileIconProvider):
    """IconProvider(self)

    This class provides icons to QFileDialog for Python files.

    """
    def __init__(self):
        QFileIconProvider.__init__(self)

    def pixmap(self,finfo):
        if str(finfo.extension()) == 'py':
            pm = IconFilePython
        else:
            pm = None

        return pm


IconProviderInstance = IconProvider()
QFileDialog.setIconProvider(IconProviderInstance)
