/*******************************************************************************
FILENAME:      qterm.cpp
REVISION:      2001.8.12 first created.

AUTHOR:        kingson fiasco
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/
#include "global.h"

#include "qterm.h"
#include "qtermwindow.h"
#include "qtermwndmgr.h"
#include "quicklogin.h"
#include "addrdialog.h"
#include "sysconfig.h"

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <qcombobox.h>
#include <qworkspace.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qstatusbar.h>
#include <qapplication.h>
#include <qpushbutton.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qwhatsthis.h>
#include <qobjectlist.h>
#include <qvbox.h>
#include <qtabbar.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <stdio.h>
#include <qstring.h>
#include <qfontdialog.h>
#include <qfont.h>

const char * connectAddressBook = "Click this button to open the address book"
"You can also select the <b>Address Book command</b> from the File menu.";
const char * connectQuickLogin = "Click this button to login in "
"You can also select the <b>Quick Login command</b> from the File menu.";

extern char fileCfg[];

extern QString pathLib;


QTerm::QTerm()
    : QMainWindow( 0, "QTerm", WDestructiveClose )
{
    int id;

    QPixmap openIcon, saveIcon;

    
    connectTools = new QToolBar( this, "telnet operations" );
    addToolBar( connectTools, tr( "Telnet Operations" ), Top, TRUE );

//    QToolButton * fileAddressBook	= 
	    new QToolButton( QPixmap(pathLib+"pic/addr.bmp"),"Address Book",QString::null,
			   this, SLOT(addressBook()), connectTools, "Address Book" );

//    QToolButton * fileQuickLogin	= 
	    new QToolButton( QPixmap(pathLib+"pic/quicklogin.bmp"), "Quick Login", QString::null,
			   this, SLOT(quickLogin()), connectTools, "Quick Login" );


    (void)QWhatsThis::whatsThisButton( connectTools );


    QPopupMenu * file = new QPopupMenu( this );
    menuBar()->insertItem( "&File", file );

    id = file->insertItem( "&Address Book", this, SLOT(addressBook()), 0 );

    file->setWhatsThis( id, connectAddressBook );

    id = file->insertItem( "&Quick Login",
			   this, SLOT(quickLogin()), 0 );
    file->setWhatsThis( id, connectQuickLogin );

    file->insertSeparator();
    file->insertItem( "&Exit", qApp, SLOT( closeAllWindows() ), 0 );

    QPopupMenu * option = new QPopupMenu( this );
    menuBar()->insertItem("&Option", option );

    option->insertItem( "Font", this, SLOT( font() ), 0 );
    
    windowsMenu = new QPopupMenu( this );
    windowsMenu->setCheckable( TRUE );
    connect( windowsMenu, SIGNAL( aboutToShow() ),
	     this, SLOT( windowsMenuAboutToShow() ) );

    menuBar()->insertItem( "&Windows", windowsMenu );
    menuBar()->insertSeparator();

    QPopupMenu * help = new QPopupMenu( this );
    menuBar()->insertItem( "&Help", help );
    help->insertItem( "&About", this, SLOT(about()), Key_F1);
    help->insertItem( "About&Qt", this, SLOT(aboutQt()));
    help->insertSeparator();
    help->insertItem( "What's &This", this, SLOT(whatsThis()), SHIFT+Key_F1);

    QVBox* vb = new QVBox( this );
    vb->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
    ws = new QWorkspace( vb );
    setCentralWidget( vb );

    tabBar=new QTabBar(statusBar(),0);
    tabBar->setShape(QTabBar::TriangularBelow);
    statusBar()->addWidget(tabBar,50,TRUE);
    
    wndmgr=new QTermWndMgr();

    connect(tabBar,SIGNAL(selected(int)),this,SLOT(selectChange(int)));
 
    CSysConfig  conf( fileCfg );

#ifndef Q_WS_X11
	if( strcmp(conf.szReadCapItem("global","max"),"1")==0 )
		showMaximized();
	else
#endif
	{
		const char * size = conf.szReadCapItem("global","size");
		if( size!= NULL)
		{
			int x,y,cx,cy;
			sscanf(size,"%d %d %d %d",&x,&y,&cx,&cy);
			resize(QSize(cx,cy));
			move(QPoint(x,y));
		}
	}
    
}


QTerm::~QTerm()
{
    delete wndmgr;
}



void  QTerm::newWindow()
{
    QString qs;

    QIconSet* icon=new QIconSet(QPixmap(pathLib+"pic/tabpic.bmp"));
    
    QTab *qtab=new QTab(*icon,QString::fromLocal8Bit(strHost));

    
    
    QTermWindow* w = new QTermWindow( ws, 0, WDestructiveClose );
    
    w->setParam(addrParam);
    w->setCaption(QString::fromLocal8Bit(addrParam[NAME]));
    w->setIcon( QPixmap( pathLib+"pic/document.xpm" ) );

  
    wndmgr->addWindow(w,qtab,icon);
  
    tabBar->addTab( qtab);
    tabBar->updateGeometry();
    tabBar->update();
//    if ( ws->windowList().isEmpty() )
	w->showMaximized();
//    else
//	w->show();
    
    w->setFocus();
    wndmgr->activateTheTab(w);
    
}


void QTerm::closeWindow()
{
    QTermWindow* m = (QTermWindow*)ws->activeWindow();
    if ( m )
	m->close();
}

void QTerm::about()
{
    QMessageBox::about( this, "About QTerm",
			"QTerm(Quick Terminal)is a BBS client in linux\n "
			"based on QT-2.3.0.");
}


void QTerm::aboutQt()
{
    QMessageBox::aboutQt( this, "Qt Application Example" );
}


void QTerm::windowsMenuAboutToShow()
{
    windowsMenu->clear();
    int cascadeId = windowsMenu->insertItem("&Cascade", ws, SLOT(cascade() ) );
    int tileId = windowsMenu->insertItem("&Tile", ws, SLOT(tile() ) );
    if ( ws->windowList().isEmpty() ) {
	windowsMenu->setItemEnabled( cascadeId, FALSE );
	windowsMenu->setItemEnabled( tileId, FALSE );
    }
    windowsMenu->insertSeparator();
    QWidgetList windows = ws->windowList();
    for ( int i = 0; i < int(windows.count()); ++i ) {
	int id = windowsMenu->insertItem(windows.at(i)->caption(),
					 this, SLOT( windowsMenuActivated( int ) ) );
	windowsMenu->setItemParameter( id, i );
	windowsMenu->setItemChecked( id, ws->activeWindow() == windows.at(i) );
    }
}

void QTerm::windowsMenuActivated( int id )
{
    QWidget* w = ws->windowList().at( id );
    if ( w ) {
	w->showNormal();
	w->setFocus();
    }
}

void QTerm::selectChange(int n)
{
    QString qs;
    qs.sprintf("%d",n);
//    printf(qs+"  selectedChange\n");
    QTab *qtab=tabBar->tab(n);
    wndmgr->activateTheWindow(qtab);
}

void QTerm::addressBook()
{
	addr = new addrDialog(this);
		
	if(addr->exec()==1)
	{
		strHost=addr->hostnameLineEdit->text().local8Bit();
		
		addrParam.clear();
		for(int i=0;i<ITEMS;i++)
		{
			addrParam.append(addr->addrCurrent[i]);
		}
		newWindow();
	}
	delete addr;
//	printf("address book\n");

}
void QTerm::quickLogin()
{
	login = new QuickLogin(this);

	if(login->exec()==1)
	{
		addrParam.clear();
		for(int i=0;i<ITEMS;i++)
		{
			addrParam.append("");
		}
		addrParam[ADDR]=login->hostnameComboBox->currentText();
		strHost=addrParam[NAME]=login->hostnameComboBox->currentText();
		addrParam[PORT]=login->portComboBox->currentText();
		QString strTmp;
		strTmp.sprintf("%d",login->ComboBox4->currentItem());
		addrParam[PROXYENABLE]=	strTmp;
		addrParam[PROXYADDR]=login->proxyLineEdit->text();
		addrParam[PROXYPORT]=login->proxyportLineEdit->text();
		addrParam[PROXYUSER]=login->usernameLineEdit->text();
		addrParam[PROXYPASSWORD]=login->passwdLineEdit->text();
			
		addrParam[FGCOLOR]="192 192 192";
		addrParam[BGCOLOR]="0 0 64";
		addrParam[ALWAYSHIGHLIGHT]="TRUE";
		addrParam[EXITWARNING]="TRUE";
		addrParam[ANTIIDLESTRING]="^l";
		newWindow();
	}

	delete login;

//	printf("quick login\n");

}

void QTerm::font()
{

	bool ok;
	QFont font = QFontDialog::getFont(&ok,qApp->font());
	if(ok==true)
	{
		qApp->setFont(font,TRUE);
	}	

}
void QTerm::closeEvent(QCloseEvent *cls)
{
	if((wndmgr->connectionCount())&&(addrParam[EXITWARNING]=="TRUE"))
	{
		QMessageBox mb( "QTerm",
                            "Connected,Do you still want to exit?",
                            QMessageBox::Warning,
                            QMessageBox::Yes | QMessageBox::Default,
                            QMessageBox::No  | QMessageBox::Escape ,
                            0,this,0,true);
            if ( mb.exec() == QMessageBox::Yes )
            {
		    savePosition();
		    cls->accept();
	    }
        }
        else
        {
	    savePosition();
            cls->accept();
        }
}
void QTerm::savePosition()
{
	//save window position and size
	//BUG: always return true in X11

	CSysConfig conf( fileCfg );
#ifndef Q_WS_X11
	if( isMaximized() )
	{
		conf.bChangeCapItem("global","max", "1");
	}
	else
#endif
	{
		QString	tmp;
		tmp.sprintf("%d %d %d %d",x(),y(),width(),height());
		conf.bChangeCapItem("global","size",tmp);
		conf.bChangeCapItem("global","max","0");
	}

	conf.bChangeCapItem("global","font",qApp->font().family().local8Bit());
	
	QCString pt;
	pt.setNum( qApp->font().pointSize() );
	conf.bChangeCapItem("global","pointsize",pt);
	
	conf.bSave( fileCfg );
}


