/*******************************************************************************
FILENAME:      qtermdecode.cpp
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson benben00
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/
#include "qtermdecode.h"
#include "global.h"
#include <math.h>
#include <stdlib.h>


/************************************************************************/
// state for FSM
// please read ANSI decoding
StateOption QTermDecode::normalState[] =
{
    { CHAR_CR, &QTermDecode::cr,			normalState },
    { CHAR_LF, &QTermDecode::lf,			normalState },
    { CHAR_FF, &QTermDecode::ff,			normalState },
    { CHAR_TAB,  &QTermDecode::tab,			normalState },
    { CHAR_BS,  &QTermDecode::bs,			normalState },
    { CHAR_BELL,  &QTermDecode::bell,			normalState },
    { CHAR_ESC, 0,					escState },
    { CHAR_NORMAL, &QTermDecode::normalInput,  		normalState }
};

// state after a ESC_CHAR
// only for BBS, so I reduce a lots
StateOption QTermDecode::escState[] =
{
    { '[', &QTermDecode::clearParam,  		bracketState },
    { CHAR_NORMAL, 0,					normalState }
};

// state after '*['
StateOption QTermDecode::bracketState[] =
{
    { '0', &QTermDecode::paramDigit,		bracketState },
    { '1', &QTermDecode::paramDigit,		bracketState },
    { '2', &QTermDecode::paramDigit,		bracketState },
    { '3', &QTermDecode::paramDigit,		bracketState },
    { '4', &QTermDecode::paramDigit,		bracketState },
    { '5', &QTermDecode::paramDigit,		bracketState },
    { '6', &QTermDecode::paramDigit,		bracketState },
    { '7', &QTermDecode::paramDigit,		bracketState },
    { '8', &QTermDecode::paramDigit,		bracketState },
    { '9', &QTermDecode::paramDigit,		bracketState },
    { ';', &QTermDecode::nextParam,		bracketState },
    { 'D', &QTermDecode::cursorLeft,		normalState },
    { 'B', &QTermDecode::cursorDown,		normalState },
    { 'C', &QTermDecode::cursorRight,		normalState },
    { 'A', &QTermDecode::cursorUp,			normalState },
    { 'H', &QTermDecode::cursorPosition,  		normalState },
    { 'f', &QTermDecode::cursorPosition,  		normalState },
    { 'P', &QTermDecode::deleteStr,		normalState },
    { 's', &QTermDecode::saveCursor,		normalState },
    { 'u', &QTermDecode::restoreCursor,		normalState },
    { 'M', &QTermDecode::deleteLine,		normalState },
    { 'J', &QTermDecode::eraseDisplay,		normalState },
    { 'K', &QTermDecode::eraseLine,		normalState },
    { 'L', &QTermDecode::insertLine,		normalState },
    { 'm', &QTermDecode::getAttr,			normalState },
    { '@', &QTermDecode::insertStr,		normalState },
    { 'X', &QTermDecode::eraseStr,			normalState },

    { CHAR_CR, &QTermDecode::cr,			bracketState },
    { CHAR_LF, &QTermDecode::lf,			bracketState },
    { CHAR_FF, &QTermDecode::ff,			bracketState },
    { CHAR_TAB,  &QTermDecode::tab,			bracketState },
    { CHAR_BS,  &QTermDecode::bs,			bracketState },
    { CHAR_BELL,  &QTermDecode::bell,			bracketState },
    { CHAR_NORMAL, 0,					normalState }
};

QTermDecode::QTermDecode( QList<QTermTextLine> *list )
{
	lineList = list;
	currentState = /*QTermDecode::*/normalState;
	defaultAttr = COLORPAIR( /*0x4b*/NO_COLOR ) | EXTRAATTR( NO_ATTR );

	caretX = 0;
	caretY = 0;

	m_attr = defaultAttr;

	nBBSCode = 0;
}

QTermDecode::~QTermDecode()
{
}

void QTermDecode::setBBSCode( int nCode )
{
	nBBSCode = nCode;
}
// precess input string from telnet socket
//void QTermDecode::ansiDecode( const QCString &cstr, int length )
void QTermDecode::ansiDecode( char *cstr, int length )
{	
	inputData = cstr;
	inputLength = length;//inputData.length();

	dataIndex = 0;
	bBell = false;
	
	bPage = false;
	
	int i;
	StateOption *lastState;

	// here we use FSM to ANSI decoding
	// use switch case is ok too
	// but i think use function pointer array can make this clear
	// you can see the defination at the beginning
	while ( dataIndex < inputLength )	
	{
		// current state always be initialized to point to the deginning of three structures
		// ( normalState, escState, bracketState )
		i = 0;
		while ( currentState[i].byte != CHAR_NORMAL && currentState[i].byte != inputData[dataIndex] )
			   i++;

		// action must be allowed to redirect state change
		// get current state with input character i ( hehe, current now become last one )
		lastState = currentState + i;	// good !!

		if ( lastState->action != 0 )
			( this->*( lastState->action ) )();
		
		// reinit current state	
		currentState = lastState->nextState;

		dataIndex++;
	}
}
	
// fill letters into char buffer
void QTermDecode::normalInput()
{
	if ( inputData[dataIndex] < 0x20 && inputData[dataIndex] >= 0x00 )	// not print char
		return;

	if ( caretX >= LINECHARNUM )
		caretX = LINECHARNUM - 1;
	//	nextLine();
	
	int n = 0;
	while ( ( inputData[dataIndex + n] >= 0x20 || inputData[dataIndex + n] < 0x00 ) && ( dataIndex + n ) < inputLength && caretX + n < LINECHARNUM )
		n++;


	QCString cstr;
	//cstr = inputData.mid( dataIndex, n );
	cstr = QCString( inputData + dataIndex, n + 1 );	// for qcstring must end by '\0'
	
	//if ( caretY >= LINENUM )
	//	qDebug( " out of range " );

	currentLine = lineList->at( caretY );
	//if ( 0 /*bInsert*/ )
	//	currentLine->insertText( cstr, m_attr, caretX );
	//else
		currentLine->replaceText( cstr, m_attr, caretX );

	//if ( caretY < LINENUM )
	//	drawChangeLine( caretY );
		
	caretX += n;
	n--;
	dataIndex += n;

	///kingson 12-20-01
	//because the caret isnot at the left-bottom when reading mail
	if ( caretY == LINENUM-1 ) //if ( caretX == LINECHARNUM-1 &&  caretY == LINENUM-1)
		bPage = true;
}

// non-printing characters functions
void QTermDecode::cr()
{
//	drawCaret( false );
	moveCursor( 0, caretY );
}

void QTermDecode::lf()
{
//	drawCaret( false );

	if (caretY < LINENUM - 1 )
		moveCursor( caretX, caretY + 1 );
	else
		scrollLines( 0, LINENUM - 2, 1 );
}

void QTermDecode::ff()
{
	clearArea(0, 0, LINECHARNUM, LINENUM, m_attr );
	
	moveCursor( 0, 0 );
}

void QTermDecode::tab()
{
	int x = ( caretX + 8 ) & -8;	// good !!

	moveCursor( x, caretY );
}

void QTermDecode::bs()
{
	moveCursor( caretX - 1, caretY );
}

void QTermDecode::bell()
{
//	if ( bAutoReply )
//	{
//		QCString cstr = "rI am not here, sorry\n";
//	
//		pTelnet->write( cstr, cstr.length() );
		
	//	bAutoReply = false;
//	}		
//	if ( bBeep )
//		qApp->beep();
//	bBellReceive = true;
	bBell = true;
}

void QTermDecode::nextLine()
{
	cr();
	lf();
}

// parameters functions
void QTermDecode::clearParam()
{
	nParam = 0;
	memset( param, 0, sizeof(param) );
	bParam = false;
}

// for performance, this grabs all digits
void QTermDecode::paramDigit()
{
	bParam = true;
	
	// make stream into number
	// ( e.g. this input character is '1' and this param is 4
	// after the following sentence this param is changed to 41
	param[nParam] = param[nParam]*10 + inputData[dataIndex] - '0';
}

void QTermDecode::nextParam()
{
	nParam++;
}

// cursor functions
void QTermDecode::moveCursor( int x, int y )
{
	// detect index boundary	
	if ( x >= LINECHARNUM )
		x = LINECHARNUM - 1;
	if ( x < 0 )
		x = 0;

	if ( y >= LINENUM )
		y = LINENUM - 1;
	if ( y < 0 )
		y = 0;
		
	//drawCaret( false );
	caretX = x;
	caretY = y;

	if ( x == LINECHARNUM-1 && y == LINENUM-1 )
		bPage = true;
	//drawCaret( true );	
	//repaint();
}

void QTermDecode::restoreCursor()
{
	moveCursor( saveX, saveY );
}

void QTermDecode::cursorLeft()
{
	int n = param[0];
	if ( n < 1 )
		n = 1;

	moveCursor( caretX - n, caretY );
}

void QTermDecode::cursorRight()
{
	int n = param[0];
	if ( n < 1 )
		n = 1;

	moveCursor( caretX + n, caretY );
}

void QTermDecode::cursorUp()
{
	int n = param[0];
	if ( n < 1 )
		n = 1;

	moveCursor( caretX, caretY - n );
}

void QTermDecode::cursorDown()
{
	int n = param[0];
	if ( n < 1)
		n = 1;

	moveCursor( caretX, caretY + n );
}

void QTermDecode::cursorPosition()
{
	int x = param[1];	
	int y = param[0];	

	moveCursor( x - 1, y - 1 );
}

// delete functions
void QTermDecode::deleteStr()
{
	int n = param[0];
	if ( n < 1 )
		n = 1;

	int x = LINECHARNUM - caretX;
	if ( n >= x )
		clearArea( caretX, caretY, x, 1, m_attr );
	else
		shiftStr( caretY, caretX, x, -n );
}

void QTermDecode::deleteLine()
{
	int n = param[0];
	if ( n < 1 )
		n = 1;
		
	int y = LINENUM - caretY;
	if ( n >= y )
		clearArea( 0, caretY, LINECHARNUM, y, m_attr );
	else
		scrollLines( caretY + n, LINENUM - 1, n );
}

// insert functions
void QTermDecode::insertStr()
{
	int n = param[0];
	if ( n < 1 )
		n = 1;
		
	int x = LINECHARNUM - caretX;
	if ( n >= x )
		clearArea(caretX, caretY, x, caretY, m_attr );
	else
		shiftStr( caretY, caretX, x, n );
}

void QTermDecode::insertLine()
{
	int n = param[0];
	if ( n < 1 )
		n = 1;
		
	int y = LINENUM - caretY;
	if ( n >= y )
		clearArea( 0, caretY, LINECHARNUM, y, m_attr );
	else
		scrollLines( caretY, y - 1, -n );
}

// erase functions
void QTermDecode::eraseStr()
{
	int n = param[0];

	if ( n < 1 )
		n = 1;
		
	int x = LINECHARNUM - caretX;
	if ( n > x )
		n = x;

	clearArea( caretX, caretY, n, 1, m_attr );
}

void QTermDecode::eraseLine()
{
	switch ( param[0] )
	{
	case 0:
		clearArea( caretX, caretY, LINECHARNUM - caretX, 1, m_attr );
		break;
	case 1:
		clearArea( 0, caretY, caretX, 1, m_attr );
		break;
	case 2:
		clearArea( 0, caretY, LINECHARNUM, 1, m_attr );
		break;
	default:
		break;
	}
}

void QTermDecode::eraseDisplay()
{
	switch ( param[0] )
	{
	case 0:
		clearArea( caretX, caretY, LINECHARNUM - caretX, 1, m_attr );
		if ( caretY < LINENUM - 1 )
			clearArea( 0, caretY + 1, LINECHARNUM, LINENUM - caretY - 1, m_attr );
		break;
	case 1:
		clearArea( 0, caretY, caretX, 1, m_attr );
		if ( caretY > 0 )
			clearArea( 0, 0, LINECHARNUM, caretY - 1, m_attr );
		break;
	case 2:
		clearArea( 0, 0, LINECHARNUM, LINENUM, m_attr );
		break;
	}
}


void QTermDecode::getAttr()
{
	// get all attributes of character
	
	if ( !nParam && param[0] == 0 )
	{
		m_attr = defaultAttr ;
		return;
	}

	char cp = GET_COLORPAIR( m_attr );
	char ea = GET_EXTRAATTR( m_attr );
	for ( int n = 0; n <= nParam; n++ )
	{
		if ( param[n]/10 == 4 )	// background color
		{
			cp = cp & ~BG_MASK;
			cp += BG( param[n]%10 );
		}
		else if ( param[n]/10 == 3 )	// front color
		{
			cp = cp & ~FG_MASK;
			cp += FG( param[n]%10 );
		}
		else
		{
			switch ( param[n] )
		 	{
			case 0:	// attr off
				cp = GET_COLORPAIR( defaultAttr );//NO_COLOR;
				ea = GET_EXTRAATTR( defaultAttr );//NO_ATTR;
				break;
			case 1:	// bold
				ea = BOLD( ea );
				break;
			case 2:	// dim
				ea = DIM( ea );
				break;
			case 4:	// underline
				ea = UNDERLINE( ea );
				break;
			case 5:	// blink
				ea = BLINK( ea );
				break;
			case 7:	// reverse
				ea = REVERSE( ea );
				break;
			case 8:	// invisible
				ea = INVISIBLE( ea );
				break;
			default:
				break;
			}
		}
	}

	m_attr = COLORPAIR( cp ) | EXTRAATTR( ea );
}

void QTermDecode::scrollLines( int startY, int endY, int num )
{
	if ( !num )
		return;


	if ( num > 0 )
	{
		while ( num )
		{
			lineList->remove( startY );
			lineList->append( new QTermTextLine( nBBSCode) );
			num--;
		}
	}

	if ( num < 0 )
	{
		//num = -num;
		while ( num )
		{
			lineList->remove( endY );
			lineList->prepend( new QTermTextLine( nBBSCode ) );
			num++;
		}
	}
	
//	for ( uint i = 0; i < lineList.count(); i++ )
//	{
//		drawEraseRect( 0, i, LINECHARNUM, 1, m_attr );
//		drawLine( i );
//	}
}

// shift str in one line
// num > 0 shift right
void QTermDecode::shiftStr( int index, int startX, int len, int num )
{
	if ( !num )
		return;
	
	QCString cstr;
	cstr.fill( ' ', abs( num ) );
	
	QTermTextLine *temp = lineList->at( index );

	if ( num > 0 )
	{
		temp->insertText( cstr, m_attr, startX );
		return;
	}

	if ( len + startX > temp->getLength() )
		len = temp->getLength() - startX;

	if ( num < 0 )
	{
		temp->deleteText( startX + num, -num );
		temp->insertText( cstr, m_attr, startX + len + num );
	
		return;
	} 							
}

void QTermDecode::clearArea(int startX, int startY, int width, int height, short attr )
{
	QCString cstr;
	cstr.fill( ' ', width );

	QTermTextLine *temp;
	
	if ( startY < 0 )
		startY = 0;
	if ( height > (int)( lineList->count() - startY ) )
		height = lineList->count() - startY;

	for ( int i = startY; i < height + startY; i++ )
	{
		temp = lineList->at( i );
		temp->replaceText( cstr, attr, startX );

		if ( startX == 0 || width == LINECHARNUM )
		{	
			temp->bBlink = false;
			temp->changeDrawn();
		}
	}

//	drawEraseRect( startX, startY, width, height, attr );
}
