#ifndef _QTERMSCREEN_H_
#define _QTERMSCREEN_H_

#include <qwidget.h>
#include <qpopupmenu.h>
#include "qtermtextline.h"
#include <qlist.h>

class QPainter;
class QPixmap;
class QPoint;
class QCursor;
//class QList;
class QTimer;
class QTermWindow;

//	class QTermScreen

class QTermScreen : public QWidget
{
	Q_OBJECT
public:
	QTermScreen( QWidget *parent = 0, const char *name = 0, WFlags f = 0 ,QString="192 192 192",QString="0 0 0",QString = 0);// WStyle_Customize | WStyle_NoBorderEx );
 	~QTermScreen();

	void setTextLineList( QList<QTermTextLine> *list );
        void setCurrentCaret( int x, int y )	{ caretX = x; caretY = y; }
	void setPageState( int pageState, int selectLine, int menuStart, int menuLength  );	
	

	QColor getFGColor()	{ return m_color[7]; }
	QColor getBGColor()	{ return m_color[0]; }
	QColor getCaretColor()	{ return caretColor; }
	bool getAllHighLightedState()	{ return bAllHighLighted; }
	bool getBGPixmapState()	{ return bBGPixmap; }
	QString getStrPixmap()	{ return strPixmap; }
	int getBorder()	{ return nBorder;}
	int getFontSize()	{ return m_font->pointSize(); }

	int getMouseX()	{ return mouseX; }
	int getMouseY()	{ return mouseY; }

	

// draw pixmap functions
	// draw widget functions
	void refreshWin();
	void eraseDisplay();

	void blinkWin();
	
// we override this virtual function to improve display	
	void repaint();	

	void focusInEvent(QFocusEvent *);
signals:
	void borderChanged();

       void mouseAction( int );	// 0 enter, 1 move, 2 press 3 release 4 leave

private:
// ****************	show functions	   *****************
	void initFont();
	void initColors();
	void initPainter();
	void initSettings();
	
// function: setBackground
// strPixmap is the pixmap file name
// Note: Qt use QString interface, and QString is Unicode	
	void setBackground( const QString& strPixmap );

// Note: we all use index for position in the following
	// change index to pixel
	int getPosX( int index ) { return ( index * nCharWidth ); }
	int getPosY( int index ) { return ( index * nCharHeight ); }

	
// function: serAttr
// explain attribute to widget	
	void setAttr( short attr );
	
// function: drawStr
// Note: str must have the same attribute	
	void drawStr( const QString& str, short attr, int x, int y, int length );
	
// each letter in the line will get the attribute equal to ( itsOwnAttr | specialAttr )
// this can support reverse display easier.	
	void drawLine( int index, short specialAttr  = 0 );
	void drawChangeLine( int index, short specialAttr = 0 );
	
	void drawEraseRect( int startX, int startY, int width, int height, short attr );
	//void drawScrollLines( int startY, int endY, int num );
	void drawRefreshRect( int startX, int startY, int width, int height );

	void drawCaret( bool bShow );

protected:
	void paintEvent( QPaintEvent * );
	void timerEvent( QTimerEvent *e );
	
// these 3 virtual functions give mouse support	
	void mouseMoveEvent( QMouseEvent *e );
	void mousePressEvent( QMouseEvent * );
	void mouseReleaseEvent( QMouseEvent *e );
	void enterEvent( QEvent * );
	void leaveEvent( QEvent * );
///kingson
	virtual void resizeEvent(QResizeEvent *re);
///

public:
// *********** 	show params 	**************

	QPainter *painter;
	QFont *m_font;
	int nFontSize;
	QFontMetrics *fm;
	int nCharWidth, nCharHeight, nCharAscent, nCharDescent;
	QString rawFontName;
	QString fontFamily;
	QColor *m_color;
	QColor defaultFG, defaultBG, caretColor;

	short m_attr;
	//char m_colorpair;
	//char m_extraAttr;	

	QCursor *m_cursor;
	QPixmap *pm, *backPm;

	int caretX, caretY;//, saveX, saveY;

	int mouseX, mouseY;//, backupX, backupY;
	
	bool bCursorVisible;
	bool bBlink;
	
	bool bMouseSupp;
	
	QString strShow;

	int blinkTimerID;

	// **********settings
	bool bBGPixmap;
	QString strPixmap;
	short defaultAttr;	// i think the better way is to change color[0] and color[7]
				// to change fg color and bg color
				// so i save the two colors at initialization
	
	int nBlinkTime;		// blink interal
	
	bool bAllHighLighted;	// all char be high light

	// if necessary, i will use defferent border size 
	int nBorder;


// ********** text params 	****************	
	QTermTextLine *currentLine;
	QList<QTermTextLine> *lineList;

	int nPageState, nSelectLine, nMenuStart, nMenuLength;

	QTermWindow* parentWin;
///kingson
	int beginX,beginY,endX,endY;
	bool bSelecting,bSelected;
	QString strSelectText;
	void drawSelectArea(int,int,int,int);
	void redrawSelectArea(int,int,int,int);
	void setSelectText();
///
	
	QPopupMenu* popMenu;
	
};

#endif

