---
layout: ja
title: Rabbiter
---
== Rabbiterとは

RabbiterはTwitterから発表に関連するツイートを収集して、それをコメントと
してRabbitに流しこむためのツールです。

日本Ruby会議など公開されたイベントで発表する場合は、観客が発表を聴きな
がらコメントをTwitterに書き込むことが増えてきました。Rabbiterを使うとそ
のようなコメントをRabbitで表示しているスライド中に表示することができま
す。

発表者に余裕がある場合は、発表中にそのコメントに返事をして観客の意見を
反映した発表にすることもできます。観客は他の観客のコメントも知ることが
でき、発表中に自分とは違った視点の考えを取り入れながら発表を聴くことが
できます。ただし、発表内容よりも観客のコメントの方に観客の注意が向いて
しまう危険もあることに注意してください。観客のコメントに負けないくらい
魅力的な発表となるように事前準備をしっかりしましょう。

== インストール

RubyGemsでインストールできます。関連パッケージも一緒にインストールされ
ます。

  % gem install rabbiter

=== OS X特有のインストール手順

Rabbiterに必要なパッケージは自動でインストールされますが、OS Xでは足り
ないパッケージがあります。

((%glib-networking%))パッケージを自分でインストールする必要があります。
Homebrewを使っているなら以下のようにインストールしてください。

  % brew install glib-networking

== 使い方

Rabbiterが収集するツイートは特定のキーワードで絞り込みます。最近のイベ
ントではイベント用のハッシュタグが指定されていることが多いので、それを
指定するのがよいでしょう。例えば、ハッシュタグが「#rubykaigi」の場合は
以下のように実行します。

  % rabbiter --filter "#rubykaigi"

Rabbiterを起動した後にキーワードを含むツイートが投稿されるとすぐに収集
します((-これは((<Twitterのストリーミング
API|URL:https://dev.twitter.com/docs/streaming-apis>))というものを使っ
ているからです。-))。

Rabbitが起動していない場合は以下のようなエラーメッセージが表示されます。

  [ERROR]
  Rabbiter: DRb::DRbConnError: druby://localhost:10101 - #<Errno::ECONNREFUSED: 接続を拒否されました - connect(2)>

RabbitとRabbiterはどちらを先に起動しても大丈夫です。上記のエラーメッセー
ジが出力された後に以下のようにRabbitを起動してもスライド上にTwitterから
のメッセージが表示されます。

  % rabbit rabbit-theme-bench-ja.gem

今回の例の「#rubykaigi」は日本Ruby会議中以外はあまり使われないのでテス
トには向いていません。動作確認をするなら「twitter」というキーワードがお
すすめです。常に世界中の誰かが「twitter」というキーワードをツイートして
います。

  % rabbiter --filter "twitter"

スライドにツイートが表示されましたか？
それでは発表の準備をしっかりして発表に備えてください。

== より詳しい使い方

通常はここまで説明した使い方で十分ですが、それでは足りないこともありま
す。そのようなときのためにより詳しい使い方を説明します。

=== 複数のキーワードを登録する

多くのイベントではハッシュタグが1つですが、複数のハッシュタグを設定して
いる場合もあります。例えば、イベント全体のハッシュタグとセッションごと
のハッシュタグを設定している場合もあります。また、ハッシュタグだけでは
なく関連するキーワードを含むツイートもコメントとして取り込みたい場合が
あります。例えば、「#rubykaigi」を含むツイートだけではなく「Ruby」を含
むツイートも取り込みたいという場合です。

このように複数のキーワードを登録したい場合は((%--filter%))オプションを
キーワードの数だけ指定してください。例えば、「#rubykaigi」と「Ruby」を
キーワードとして登録したい場合は以下のようにします。

  % rabbiter --filter "#rubykaigi" --filter "Ruby"

=== ユーザーの言語で絞り込む

世界的なキーワードは世界中で使われています。例えば、「twitter」というキー
ワードは世界中でツイートされているため、いろんな言語のツイートが収集さ
れます。日本で開催されているイベントでは、日本語のツイートは関連するツ
イートである可能性が高いですが、フランス語のツイートは関連する可能性は
低いでしょう。

スライドには多くのコメントを表示したくなるかもしれませんが、発表してい
る間は観客にはできるだけ発表に集中できるように、表示するコメントはでき
るだけ発表に関連するものだけにした方にしましょう。ツイートが関連するか
どうかをツイートしたユーザーの言語で絞り込むことができます。

例えば、自分の言語を日本語に設定しているユーザーのツイートだけにする場
合は以下のように((%--user-language "ja"%))を指定します。

  % rabbiter --filter "#rubykaigi" --user-language "ja"

((%--filter%))と同じように((%--user-language%))も複数回指定することがで
きます。複数回指定すると指定したどれかの言語のユーザーのツイートのみが
収集されます。以下は日本語またはフランス語に設定したユーザーのツイート
のみを収集する例です。

  % rabbiter --filter "#rubykaigi" --user-language "ja" --user-language "fr"

=== 違うホストで起動しているRabbitにコメントを送る

TODO

=== もっと知りたい

((%--help%))オプションを指定すると使えるオプションがすべて表示されます。
自分が使いたい機能がないか調べてみてください。

  % rabbiter --help

== 作者

  * Kouhei Sutou <kou@cozmixng.org>
  * OBATA Akio <obata@lins.jp>

== 著作権

著作権はそれぞれのコードを書いた人が持っています。つまり、コミットされ
たコードの著作権はそのコミッタが持っていて、パッチのコードの著作権はそ
のパッチ作者が持っています。

== ライセンス

GPLv2 or laterです。詳しくはGPLファイルを見てください。取り込まれたパッ
チやコードなどを提供してもらった場合、それらのライセンスがGPLv2 or
laterとすることに同意してもらったこととします。また、それらも含めて須藤
がライセンスを変更できる権利を持つことに同意してもらったこととします。

== メーリングリスト

((<Rabbitのユーザーページ
|URL:http://rabbit-shocker.org/ja/users.html>))を参照してください。

== 開発への参加方法

=== リポジトリ

Rabbiterのリポジトリは((<GitHub|URL:https://github.com/rabbit-shocker/rabbiter/>))にあります。

=== コミットメール

以下のメーリングリストにコミットメール毎に変更点が流れます。メーリング
リストに参加することで開発状況を確認できます。メーリングリストに参加す
るには以下のようなメールを送信してください。

  To: commit@ml.rabbit-shocker.org
  Cc: null@rabbit-shocker.org
  Subject: 登録

  登録

=== バグの報告方法

ご意見ご要望不具合報告等は作者へのメール、メーリングリスト、((<GitHubの
Issues|URL:https://github.com/rabbit-shocker/rabbiter/issues>))をご利用くださ
い。

== 感謝

以下の方々はRabbiterを助けてくれたみなさんです。ありがとうございま
す！！！

  * おばたさん: 最初のバージョンを書いてくれました。

