
class FMProjectVO:
    def __init__(self, projectname=None, shortname=None, groupid="", sf_projectname=""):
        self.projectname = projectname
        self.shortname = shortname
        self.groupid = groupid
        self.sf_projectname = sf_projectname

    def copy(self):
        return FMProjectVO(self.projectname,
                           self.shortname,
                           self.groupid,
                           self.sf_projectname)

    def __eq__(self, cmp):
        if self.projectname == cmp.projectname:
            return True
        else:
            return False


    def __cmp__(self, other):
        if self.projectname < other.projectname: return -1
        elif self.projectname == other.projectname: return 0
        else: return 1
        

    def __repr__(self):
        return "FMProjectVO: <%s - %s - %s - %s>" %(self.projectname,
                                                    self.shortname,
                                                    self.groupid,
                                                    self.sf_projectname)
    
    def __hash__(self):
        #return hash("%s:%s:%s" % (self.projectname, self.shortname, self.groupid))
        return hash(self.projectname)

        
    def setProjectName(self, projectname):
        self.projectname = projectname

    def setShortName(self, shortname):
        self.shortname = shortname

    def setGroupId(self, groupid):
        self.groupid = groupid

    def setSFProjectName(self, sf_projectname):
        self.sf_projectname = sf_projectname

    def getProjectName(self):
        return self.projectname

    def getShortName(self):
        return self.shortname

    def getGroupId(self):
        return self.groupid

    def getSFProjectName(self):
        return self.sf_projectname
    
    def dump(self):
        print "FMProjectVO: %s - %s - %s - %s" % (self.packagename,
                                                  self.shortname,
                                                  self.groupid,
                                                  self.sf_projectname)

                
