/* iterator.h - The iterator support-data structure.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __ITERATOR_H__
#define __ITERATOR_H__

/* POSIX */
#include <sys/types.h>
/* POSIX/gnulib */
#include <stdbool.h>
/* common */
#include "common.h"

typedef void (*IteratorFunc)(void *);

typedef struct _IteratorClass IteratorClass;
typedef struct _Iterator Iterator;

struct _IteratorClass {
	bool (*has_next)(Iterator *it);
	void *(*next)(Iterator *it);
	void (*remove)(Iterator *it);
	void (*free)(Iterator *it);
	void (*restart)(Iterator *it);
	void *(*previous)(Iterator *it);
	void (*add)(Iterator *it, void *value);
};

struct _Iterator {
	IteratorClass *class;
};

bool iterator_has_next(Iterator *it);
void *iterator_next(Iterator *it);
void iterator_free(Iterator *it);
void iterator_remove(Iterator *it);
void iterator_restart(Iterator *it); /* FIXME: rename to iterator_first?*/
void *iterator_previous(Iterator *it);
void iterator_add(Iterator *it, void *value);
#define iterator_first iterator_restart

#endif
